proc genweb {} {

	set fd [open webit.html w]

	puts $fd "<html>
<body>
<pre>
	<p> 
	<a href=tybytype.html>Target selection cuts by type</a>
	<p>
 Oct 2004 SEGUE DRAFT plate designs and target count and distribution plots

 id | plate:b/f | strp | RA (J2000)DEC |   l       b   |   mu  |E(B-V)| bytype | clr/mag | Fractype| NbyType  |
"
	foreach i { 108 109 } {

	param2Chain d$i.par hh

	set ra [format %6.2f [keylget hh raCen]]
	set dec [format %6.2f [keylget hh decCen]]

	set pl [keylget hh platebright]
	set pl2 [keylget hh platefaint]

	set lb [eqToGal $ra $dec]

	set l [format %6.2f [keylget lb gLong]]	
	set b [format %6.2f [keylget lb gLat]]
		set redlist ""
	for {set lv [expr $l-1.5]} {$lv < [expr $l+1.5]} {set lv [expr $lv+0.25]} {
		for {set bv [expr $b-1.5]} {$bv < [expr $b+1.5]} {set bv [expr $bv+0.25]} {
	set ebv [format %4.2f [atDustGetval $lv $bv]]
	lappend redlist $ebv
		}
	}
	set slist [lsort -real $redlist]
	set ll [llength $slist]
	#echo $ll $slist
	set ebvmed [lindex $slist [expr $ll/2]]

	set ebv [format %4.2f [atDustGetval $l $b]]


	echo median red: $ebvmed central:$ebv
	set ebv $ebvmed
	set stripe [keylget hh stripe]

	set incl [inclFromStripeNumber $stripe]
	set node [nodeFromStripeNumber $stripe]

	set mn [eqToGC $ra $dec -node $node -incl $incl]

	set mu [format %5.1f [keylget mn mu]]

	set sstr [format %04d $stripe]

	set fn [lindex [glob d$i/counts*.txt] 0]

	set ofd [open d$i/newcounts.txt w]
	puts $ofd "BP = Bright plate $pl; FP = Faint plate $pl2"
	puts $ofd "Fiber allocation by Spectral Category per plate pair"
	puts $ofd ""
	puts $ofd "Type BP  FP Tot (Goal) Dev  Description"
	puts $ofd "---------------------------------------"

	set goal(WD) 25;set sg(WD) "Hot DA White Dwarf"
	set goal(CWD) 10;set sg(CWD) "Cool CIA White Dwarf"
	set goal(BH) 150;set sg(BH) "Blue Horizontal Branch/A star"
	set goal(FSD) 200;set sg(FSD) "F turnoff and sub-dwarf star"
    set goal(FG) 50;set sg(FG) "F/G sampling region"

	set goal(GD) 375;set sg(GD) "G star"
	set goal(KG) 100;set sg(KG) "K giant candidate star; high ppm rejected"
	set goal(MK) 100;set sg(MK) "K dwarf star"
	set goal(MD) 25;set sg(MD) "M sub-dwarf star"
	set goal(BD) 5;set sg(BD) "L,T brown dwarf star"
	set goal(LM) 150;set sg(LM) "Low Metalicity (Z) candidate"
	set goal(AGB) 10;set sg(AGB) "AGB-type (u-g,g-r) giant candidate"
    set goal(MSWD) 5;set sg(MSWD) "MS/WD pair candidate"

	set goal(MN) 1;set sg(MN) "Manual targets (known stars)"

	exec /bin/rm -f /tmp/cnt1
	system "grep QA d$i/plPlugMapP-$pl2.par | wc -l >/tmp/cnt1"
	for_file aline /tmp/cnt1 {
	set qacnt [expr [lindex $aline 0] -1]
	}
	exec /bin/rm -f /tmp/cnt1
  set sumbright 0
        set sumfaint 0

	for_file line $fn {
		set t [lindex $line 0]
		if {$t != "Counts" && $t != ""} {
			set n [lindex $line 3]
			set dev [format %4.0f [expr 100.0*($n-$goal($t))/$goal($t)]]
	puts $ofd "[format %3s $t] [format %3d [lindex $line 1]] [format %3d [lindex $line 2]] [format %3d [lindex $line 3]] [format (%3d) $goal($t)] ${dev}% $sg($t)"
  	set sumbright [expr $sumbright+[lindex $line 1]]
        set sumfaint [expr $sumfaint+[lindex $line 2]]
       
	}
	}
   puts $ofd "    $sumbright  $sumfaint ($qacnt) [expr $sumbright+$sumfaint+$qacnt] (1152)"
      
	close $ofd

puts -nonewline $fd " [format %02d $i] | $pl/$pl2 | $sstr | $ra $dec | $l $b | $mu | $ebv | <a href=d$i/newcounts.txt>counts</a> | "
	
	set g [glob d$i/cmd*gif d$i/ccd*gif]

	set ofd [open d$i/c.html w]
	puts $ofd "<html><body><pre> 
	Plate Pair: $pl $pl2  at (l,b) = ($l,$b)<p>
Color Mag diagram of candidate on plates<p>	
Color Color diagrams (u-g, g-r) (g-r, r-i)<p>
	<img src=[file tail [lindex $g 0]]> <p> 
	<img src=[file tail [lindex $g 1]]> <p> 
	<img src=[file tail [lindex $g 2]]> <p> 
	</pre></body></html>
	"
	close $ofd
	puts -nonewline $fd "<a href=d$i/c.html>CMD CCD</a> | "

#set g [glob d$i/magdist.bh*gif d$i/magdist.fsd*gif d$i/magdist.gd*gif d$i/magdist.kg*gif d$i/magdist.lm*gif d$i/magdist.mk*gif d$i/magdist.md*gif d$i/vel*gif]
set g [glob -nocomplain d$i/Fractarghg*gif]
	set ofd [open d$i/m.html w]
	puts $ofd "<html><body><pre> 
	Plate Pair: $pl $pl2  at (l,b) = ($l,$b)<p>
	"
	loop ff 0 [llength $g] {
	puts $ofd "<img src=[file tail [lindex $g $ff]]> <p>"
	}
	puts $ofd "</pre></body></html>
	"
	close $ofd
	puts -nonewline $fd "<a href=d$i/m.html>FracTyp</a> | "

	#set g [glob d$i/distdist.gd*gif d$i/distdist.mk*gif d$i/distdist.md*gif]
	set g [glob -nocomplain d$i/Ntarghg*gif]

	set ofd [open d$i/d.html w]
	puts $ofd "<html><body><pre> 
	Plate Pair: $pl $pl2  at (l,b) = ($l,$b)<p>
	"
	loop ff 0 [llength $g] {
	puts $ofd "<img src=[file tail [lindex $g $ff]]> <p>"
	}
	puts $ofd "</pre></body></html>
	"
	close $ofd
	puts -nonewline $fd "<a href=d$i/d.html>NByType  </a> | "

	puts $fd ""
	}		

	puts $fd "</pre>
</body>
</html>
"

close $fd

}
