      SUBROUTINE  iterc(nc,fatal)
c
c...Get Unique List Of Pairs
c
      INCLUDE
     *            'proc.inc'
      INTEGER
     *            i, nd1, nd2, niter, rmin, fatal, nc, err,
     *            frst, last, irmin, dmin, idmin, r, d, x, y, q
c
 9001 FORMAT (' ITERC Fatal Error N(dup1) Not Zero')
 9002 FORMAT (' NPAIR=', i8, '  Sx=', f10.2, '   Sx=', f10.2,
     *        '  NCoef=', i2, '  Niter=', i2)
 9003 FORMAT (' ITERC N(pair)=', i10, '  N(dup1)=', i10, '  N(dup2)=',
     *        i10)
 9004 FORMAT (' ITERC NPAIR Was ', i10, ' Is ', i10)
 9005 FORMAT (' ITERC Failure N(dup2)=', i10)
c
c...Get Preliminary Counts And Exit If Nothing To Do
c
  100 nd1 = 0
      nd2 = 0
      CALL iuqsrt(npair,pair1,pair2)
      DO i=1,npair-1
        IF (pair1(i).eq.pair1(i+1)) THEN
          nd1 = nd1+1
        ENDIF
      ENDDO
      CALL iuqsrt(npair,pair2,pair1)
      DO i=1,npair-1
        IF (pair2(i).eq.pair2(i+1)) THEN
          nd2 = nd2+1
        ENDIF
      ENDDO
      WRITE (*,9003) npair,nd1,nd2
      IF ((nd1.le.0).and.(nd2.le.0)) THEN
        fatal = 0
        RETURN
      ENDIF
      IF (nd1.gt.0) THEN
        WRITE (*,9001)
        fatal = -28
        RETURN
      ENDIF
c
c...Find All Multiple Detections And Find Closest And Brightest Choices
c
      last = 0
  110 frst = last+1
      IF (frst.lt.npair) THEN
        last = frst
        IF (pair2(frst).eq.pair2(last+1)) THEN
          last = last+1
  120     IF (last.lt.npair) THEN
            IF (pair2(frst).eq.pair2(last+1)) THEN
              last = last+1
              GO TO 120
            ENDIF
          ENDIF
          x = xres(frst)/100
          y = yres(frst)/100
          r = x*x + y*y
          d = d1(pair1(frst))
          rmin = r
          irmin = frst
          dmin = d
          idmin = frst
          DO i=frst+1,last
            x = xres(i)/100
            y = yres(i)/100
            r = x*x + y*y
            d = d1(pair1(i))
            IF (d.lt.dmin) THEN
              dmin = d
              idmin = i
            ENDIF
            IF (r.lt.rmin) THEN
              rmin = r
              irmin = i
            ENDIF
          ENDDO
c
c...Same Old Problem, Which To Choose?  PAIRFIND Typically Chooses
c	Brightest Of All Possible Pairs, So Maybe This Should Be The Same?
c
          q = idmin
          DO i=frst,last
            IF (i.ne.q) THEN
              pair1(i) = SANITYTAG
            ENDIF
          ENDDO
        ENDIF
        GO TO 110
      ENDIF
c
c...Remove TAGs
c
      q = 0
      DO i=1,npair
        IF (pair1(i).ne.SANITYTAG) THEN
          q = q+1
          pair1(q) = pair1(i)
          pair2(q) = pair2(i)
        ENDIF
      ENDDO
      WRITE (*,9004) npair,q
      npair = q
c
c...This Better Work!
c
      nd2 = 0
      DO i=1,npair-1
        IF (pair2(i).eq.pair2(i+1)) THEN
          nd2 = nd2+1
        ENDIF
      ENDDO
      IF (nd2.ne.0) THEN
        WRITE (*,9005) nd2
        fatal = -27
        RETURN
      ENDIF
      niter = -1
      CALL pairfit(x1, xcoef,sxcoef,sigmax, err)
      IF (err.ne.0) THEN
        WRITE (*,9001)
        fatal = 9
        RETURN
      ENDIF
      CALL pairfit(y1, ycoef,sycoef,sigmay, err)
      IF (err.ne.0) THEN
        WRITE (*,9001)
        fatal = 10
        RETURN
      ENDIF
      sigmax = 0.01D00*sigmax
      sigmay = 0.01D00*sigmay
      WRITE (*,9002) npair,sigmax,sigmay,ncoef,niter
      CALL fakeres
      fatal = 0
      RETURN
      END
