      SUBROUTINE  iterfit1(pr,xx,yy,mm,qq,zz, zcoef,sigmaz)
c
c...Fit Pairs To Mean
c
      INCLUDE
     *            'magover.inc'
      DOUBLE PRECISION
     *            zcoef(*), szcoef(NCMAX), sigmaz, x, y, z, chisq, zc,
     *            zr, m
      INTEGER
     *            xx(*), yy(*), mm(*), zz(*), pr(*), i, j, k, ising,
     *            qq(*), q
c
 9001 FORMAT (' Singular Matrix In ITERFIT')
c
c...Initialization
c
  100 DO i=1,ncoef
        zlhs(i) = 0.0D00
        DO j=1,ncoef
          zrhs(i,j) = 0.0D00
        ENDDO
      ENDDO
      chisq = 0.0
      sigmaz = TAG
c
c...Accumulation
c
      DO i=1,npair
        x = xx(pr(i))/SCALE
        y = yy(pr(i))/SCALE
        m = 0.01D00*mm(pr(i))
        q = qq(pr(i))
        z = zz(i)/SCALE
        CALL iterdv1(x,y,m,q)
        DO j=1,ncoef
          zlhs(j) = zlhs(j) + dv(j)*z
          DO k=1,ncoef
            zrhs(j,k) = zrhs(j,k) + dv(j)*dv(k)
          ENDDO
        ENDDO
      ENDDO
c
c...Inversion
c
      CALL matinv(ising)
      IF (ising.ne.0) THEN
        WRITE (*,9001)
        RETURN
      ENDIF
c
c...Coefficients
c
      DO i=1,ncoef
        zcoef(i) = 0.0D00
        DO j=1,ncoef
          zcoef(i) = zcoef(i) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Residuals And ChiSquared
c
      DO i=1,npair
        x = xx(pr(i))/SCALE
        y = yy(pr(i))/SCALE
        m = 0.01D00*mm(pr(i))
        q = qq(pr(i))
        z = zz(i)/SCALE
        CALL iterdv1(x,y,m,q)
        zc = 0.0D00
        DO j=1,ncoef
          zc = zc + zcoef(j)*dv(j)
        ENDDO
        zr = z-zc
        chisq = chisq + zr*zr
      ENDDO
      sigmaz = SQRT(chisq/(npair-(ncoef+1)))
c
c...Errors
c
      DO i=1,ncoef
        szcoef(i) = sigmaz*SQRT(zrhs(i,i))
        z = ABS(zcoef(i)/szcoef(i))
        z = MIN(z,999.9D00)
c9999   write (*,9991) i,zcoef(i),z
 9991   format(i3, 1x, 1pe14.7, 1x, 0pf6.1)
      ENDDO
c
c...Convert To User's Units
c
      sigmaz = SCALE*sigmaz
      RETURN
      END
