      SUBROUTINE  stretch1(xfactor,yfactor)
c
c...Stretch Coordinates
c
      INCLUDE
     *            'magover.inc'
      DOUBLE PRECISION
     *            xfactor, yfactor, xbar(NFMAX), ybar(NFMAX), dx, dy
      INTEGER
     *            i, f, fmax, nbar(NFMAX)
c
 9001 FORMAT (' Stretching 1 X=', f10.6, '  Y=', f10.6)
 9002 FORMAT (' Illegal Frame ', 2i12)
 9003 FORMAT (' No Stars In Frame ', i4)
c
c...Find The Mean Of Each Footprint
c
  100 WRITE (*,9001) xfactor,yfactor
      DO f=1,NFMAX
        nbar(f) = 0
        xbar(f) = 0.0D00
        ybar(f) = 0.0D00
      ENDDO
      fmax = 0
      DO i=1,n1
        f = bigbuf1(i,13)/NPIXELS
        IF ((f.lt.1).or.(f.gt.NFMAX)) THEN
          WRITE (*,9002) bigbuf1(i,13),f
      pause
        ELSE
          nbar(f) = nbar(f)+1
          xbar(f) = xbar(f)+bigbuf1(i, 9)
          ybar(f) = ybar(f)+bigbuf1(i,10)
          fmax = MAX(fmax,f)
        ENDIF
      ENDDO
      DO f=1,fmax
        IF (nbar(f).le.0) THEN
          WRITE (*,9003) f
        ELSE
          xbar(f) = xbar(f)/nbar(f)
          ybar(f) = ybar(f)/nbar(f)
        ENDIF
      ENDDO
c
c...Apply The Stretch
c
      DO i=1,n1
        f = bigbuf1(i,13)/NPIXELS
        IF ((f.ge.1).and.(f.le.fmax)) THEN
          dx = bigbuf1(i, 9)-xbar(f)
          dy = bigbuf1(i,10)-ybar(f)
          bigbuf1(i, 9) = xbar(f) + xfactor*dx
          bigbuf1(i,10) = ybar(f) + yfactor*dy
        ENDIF
        idx(i) = i
      ENDDO
      CALL iuqsrt(n1,bigbuf1(1,9),idx)
      DO i=1,13
        IF (i.ne.9) THEN
          CALL ireord(n1,idx,bigbuf1(1,i),tmp)
        ENDIF
      ENDDO
      RETURN
      END
