      PROGRAM  allhist
c
c...Historgram Various Things On The Same Piece Of Paper
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nsource = 3,
     *         nbmax = 20,
     *         wbin = 0.375,
     *         round = 50,
     *         wunits = wbin*0.1
      REAL
     *         xbin(NBMAX,NSOURCE), ybin(NBMAX,NSOURCE), x, y, ymax,
     *         ymin, xmin, xmax, bin(NBMAX)
      INTEGER
     *         nlb, j, source, xlow(NSOURCE), ylow(NSOURCE),
     *         xhigh(NSOURCE), yhigh(NSOURCE)
      CHARACTER*80
     *         lb
c
 9001 FORMAT (12x, 2f6.0)
 9002 FORMAT (' XL=', i3, '  XH=', i3, '  YL=', i3, '  YH=', i3,
     *        '  Source=', a)
 9003 FORMAT (45x, f10.0, 10x, f10.0)
c
c...Initialization
c
  100 DO source=1,NSOURCE
        xlow(source) = 0
        ylow(source) = 0
        xhigh(source) = 0
        yhigh(source) = 0
        DO j=1,NBMAX
          xbin(j,source) = 0.0
          ybin(j,source) = 0.0
        ENDDO
      ENDDO
      DO j=1,NBMAX
        bin(j) = (j-0.5)*WUNITS
      ENDDO
c
c...Outer Loop Is Over Source
c
      DO source=1,NSOURCE
        IF (source.eq.1) THEN
          lb = 'realuj.raw'
          nlb = 10
        ELSEIF (source.eq.2) THEN
          lb = 'realtaffuj.raw'
          nlb = 14
        ELSE
          lb = '../autotycho/realuj.raw'
          nlb = 23
        ENDIF
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name=lb(1:nlb),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
c
c...Inner Loop Reads The File
c
  110   READ (1,9001,end=120) x,y
        j = x/WBIN
        IF (j.le.0) THEN
          xlow(source) = xlow(source)+1
        ELSEIF (j.gt.NBMAX) THEN
          xhigh(source) = xhigh(source)+1
        ELSE
          xbin(j,source) = xbin(j,source)+1.0
        ENDIF
        j = y/WBIN
        IF (j.le.0) THEN
          ylow(source) = ylow(source)+1
        ELSEIF (j.gt.NBMAX) THEN
          yhigh(source) = yhigh(source)+1
        ELSE
          ybin(j,source) = ybin(j,source)+ 1.0
        ENDIF
        GO TO 110
  120   CLOSE (1)
        WRITE (*,9002) xlow(source),xhigh(source),ylow(source),
     *                 yhigh(source),lb(1:nlb)
      ENDDO
c
c...Plot
c
      ymax = ybin(1,1)
      DO source=1,NSOURCE
        DO j=1,NBMAX
          ymax = MAX(ymax,xbin(j,source),ybin(j,source))
        ENDDO
      ENDDO
      ymin = 0.0
      j = ymax+0.5
      j = (j-1)/ROUND + 1
      ymax = j*ROUND
      xmin = bin(1)-0.5*WUNITS
      xmax = bin(NBMAX)+0.5*WUNITS
      CALL mgoinit
      CALL mgosetup(-6)
      CALL mgoerase
      CALL mgosetlim(xmin,ymin,xmax,ymax)
      CALL mgobox(1,1)
      CALL mgoxlabel(19, 'UJ Sigma X (arcsec)')
      CALL mgoylabel(16, 'Number of Plates')
      CALL mgosetltype(0)
      CALL mgohistogram(bin,xbin(1,1),NBMAX)
      CALL mgosetltype(1)
      CALL mgohistogram(bin,xbin(1,2),NBMAX)
      CALL mgosetltype(2)
      CALL mgohistogram(bin,xbin(1,3),NBMAX)
      CALL mgoprntplot(j)
      CALL EXIT
      END
