      PROGRAM  fixsr0342
c
c...SR0342 is the ESO copy of the 300x300-mm plate to the middle of a
c	14x14 plate.  Because its cover glass is too big, it was scanned
c	upside down compared to the rest.  This program flips the X
c	coordinate and then subtracts the difference in zero points
c	so that the revised X,Y should look like the others
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         xmax = 2*(175*1000*100),
     *         dx0 =    ( 28*1000*100),
     *         dy0 =    ( 28*1000*100),
     *         nmax = 1*1000*1000
      INTEGER
     *         n, nsrc, ndst, i, j, buf(NMAX), x
      CHARACTER*64
     *         src, dst
c
 9001 FORMAT (i10)
c
c...Read Header To Get Count
c
  100 src = '/ue0/xpmm/lists/qr0342a.inf'
      dst = '/ue0/xpmm/lists/sr0342a.inf'
      nsrc = 27
      ndst = 27
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=src(1:nsrc),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9001) n
      CLOSE (1)
c
c...Copy INF and HDR
c
      CALL system('cp '//src(1:nsrc)//' '//dst(1:ndst))
      src(nsrc-2:nsrc) = 'hdr'
      dst(ndst-2:ndst) = 'hdr'
      CALL system('cp '//src(1:nsrc)//' '//dst(1:ndst))
c
c...Process DAT
c
      src(nsrc-2:nsrc) = 'dat'
      dst(ndst-2:ndst) = 'dat'
      CALL system('rm -f '//dst(1:ndst))
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name=src(1:nsrc),
     *      readonly,
     *      recl=n,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name=dst(1:ndst),
     *      recl=n,
     *      recordtype='fixed',
     *      status='new',
     *      unit=2
     *     )
c
c...Copy First 8 Records
c
      DO i=1,8
        READ  (1,rec=i) (buf(j),j=1,n)
        WRITE (2,rec=i) (buf(j),j=1,n)
      ENDDO
c
c...Process X
c
      READ (1,rec=9) (buf(j),j=1,n)
      DO j=1,n
        x = XMAX-buf(j)
        buf(j) = x-DX0
      ENDDO
      WRITE (2,rec=9) (buf(j),j=1,n)
c
c...Process Y
c
      READ (1,rec=10) (buf(j),j=1,n)
      DO j=1,n
        buf(j) = buf(j)-DY0
      ENDDO
      WRITE (2,rec=10) (buf(j),j=1,n)
c
c...Process The Last 3 Records
c
      DO i=11,13
        READ  (1,rec=i) (buf(j),j=1,n)
        WRITE (2,rec=i) (buf(j),j=1,n)
      ENDDO
      CLOSE (1)
      CLOSE (2)
      CALL EXIT
      END
