      PROGRAM  hismon
c
c...Histogram
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nbmax = 50,
     *         ndmax = 100000
      REAL
     *         xbin(NBMAX), ybin(NBMAX), save(NDMAX), s, smin, smax,
     *         xmin, xmax, ymin, ymax, wbin, buf(7)
      INTEGER
     *         nbin, nsave, nlb, i, j, which
      CHARACTER*80
     *         lb
c
 9001 FORMAT (' Which Column (1-7): ' $)
 9002 FORMAT (i1)
 9003 FORMAT (' Min=', f10.4, '   Max=', f10.4)
 9004 FORMAT (' Enter Number,Width,First: ' $)
 9005 FORMAT (i10,2f10.0)
 9007 FORMAT (5x, 7f10.0)
c
c...Inquire And Open
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='zeta.uj',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      nsave = 0
      WRITE (*,9001)
      READ  (*,9002) which
  110 READ (1,9007,err=110,end=120) (buf(i),i=1,7)
      nsave = nsave+1
      s = buf(which)
      IF (nsave.eq.1) THEN
        smin = s
        smax = s
      ELSE
        smin = MIN(s,smin)
        smax = MAX(s,smax)
      ENDIF
      save(nsave) = s
      GO TO 110
  120 CLOSE (1)
      WRITE (*,9003) smin,smax
      WRITE (*,9004)
      READ  (*,9005) nbin,wbin,xbin(1)
      DO i=2,nbin
        xbin(i) = xbin(i-1) + wbin
      ENDDO
c
c...Accumulate
c
      s = xbin(1)-wbin
      DO i=1,nsave
        j = (save(i)-s)/wbin + 1.0
        IF ((j.ge.1).and.(j.le.nbin)) THEN
          ybin(j) = ybin(j) + 1.0
        ENDIF
      ENDDO
c
c...Min/Max
c
      xmin = s
      xmax = xbin(nbin)
      ymin = 0.0
      ymax = ybin(1)
      DO i=2,nbin
        ymax = MAX(ymax,ybin(i))
      ENDDO
      ymax = 1.1*ymax
 9999 ymax = 600
c
c...Mongo
c
      CALL mgoinit
      CALL mgosetup(-6)
      CALL mgoerase
      CALL mgosetlim(xmin,ymin,xmax,ymax)
      CALL mgobox(1,1)
      CALL mgohistogram(xbin,ybin,nbin)
      CALL mgoprntplot(j)
      CALL EXIT
      END
