      PROGRAM  zetacheck
c
c...Compare ZETA And RAW Files
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nmax = 1400
      INTEGER
     *         i, zeta(NMAX), raw(NMAX), nlb, dotaff
      CHARACTER*2
     *         color
      CHARACTER*64
     *         lb
c
 9001 FORMAT (' Enter Color: ' $)
 9002 FORMAT (a)
 9003 FORMAT (i4)
 9004 FORMAT (' Illegal RAW I=', i10)
 9005 FORMAT (' Field=', i4, '  N(raw)=', i3)
 9006 FORMAT (' TAFF=(0/1): ' $)
 9007 FORMAT (i1)
 9008 FORMAT (' Illegal ZETA I=', i10)
 9009 FORMAT (' Field=', i4, '  N(zeta)=', i3)
 9010 FORMAT (' Field=', i4, '  Raw=', i3, '  Zeta=', i3)
 9011 FORMAT (i5)
c
c...Figure Out What To Do
c
  100 WRITE (*,9001)
      READ  (*,9002) color
      WRITE (*,9006)
      READ  (*,9007) dotaff
      DO i=1,NMAX
        raw(i) = 0
        zeta(i) = 0
      ENDDO
c
c...Process RAW File
c
      IF (dotaff.eq.0) THEN
        lb = 'real'//color//'.raw'
        nlb = 10
      ELSE
        lb = 'realtaff'//color//'.raw'
        nlb = 14
      ENDIF
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  110 READ (1,9003,end=120) i
      IF ((i.lt.1).or.(i.gt.NMAX)) THEN
        WRITE (*,9004) i
      ELSE
        raw(i) = raw(i)+1
      ENDIF
      GO TO 110
  120 CLOSE (1)
      DO i=1,NMAX
        IF (raw(i).gt.1) THEN
          WRITE (*,9005) i,raw(i)
        ENDIF
      ENDDO
c
c...Process ZETA File
c
      DO i=1,2
        color(i:i) = CHAR(ICHAR(color(i:i))-32)
      ENDDO
      IF (dotaff.eq.0) THEN
        lb = 'zeta.'//color
        nlb = 7
      ELSE
        lb = 'zetataff.'//color
        nlb = 11
      ENDIF
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  130 READ (1,9011,end=140) i
      IF ((i.lt.1).or.(i.gt.NMAX)) THEN
        WRITE (*,9008) i
      ELSE
        zeta(i) = zeta(i)+1
      ENDIF
      GO TO 130
  140 CLOSE (1)
      DO i=1,NMAX
        IF (zeta(i).gt.1) THEN
          WRITE (*,9009) i,zeta(i)
        ENDIF
      ENDDO
c
c...Final Check
c
      DO i=1,NMAX
        IF ((raw(i).gt.0).or.(zeta(i).gt.0)) THEN
          IF ((raw(i).eq.0).or.(zeta(i).eq.0)) THEN
            WRITE (*,9010) i,raw(i),zeta(i)
          ENDIF
        ENDIF
      ENDDO
c
c...All Done
c
      CALL EXIT
      END
