      PROGRAM  genbycd
c
c...Make BYCD.LIS For Ring Processing
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nfmax = 1100,
     *         ncmax = 4,
     *         nring = 34,
     *         nposs1 = 937,
     *         np1keep = 825,
     *         omit = 723,
     *         nsrc = 606
      INTEGER
     *         field, nfield, color, ncolor, nlb, ring(NRING), i, j,
     *         bcd(NFMAX), bnfn(NFMAX), frst(NRING), last(NRING),
     *         survey(NRING), zone(NFMAX), idx(NFMAX), tmp(NFMAX),
     *         rcd(NFMAX), rnfn(NFMAX), jzone(NFMAX)
      CHARACTER*64
     *         lb, bfn(NFMAX), rfn(NFMAX)
c
 9001 FORMAT (2i5)
 9002 FORMAT (7x, q, a)
 9003 FORMAT (10x, i3)
 9004 FORMAT (i3, 2i5, i2)
 9005 FORMAT (5i5)
c
c...Load Ring Stuff
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='rings.dat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      DO i=1,NRING
        READ (1,9004) ring(i),frst(i),last(i),survey(i)
      ENDDO
      CLOSE (1)
c
c...Open Output File
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='bycd.lis',
     *      status='unknown',
     *      unit=2
     *     )
c
c...Load POSS-I
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='../../binary/cddir/p1cd.dir',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9001) ncolor,nfield
      DO field=1,nfield
        READ (1,9002) nlb,lb
        bfn(field) = lb
        bnfn(field) = nlb
        READ (lb(1:nlb),9003) bcd(field)
        READ (1,9002) nlb,lb
        rfn(field) = lb
        rnfn(field) = nlb
        READ (lb(1:nlb),9003) rcd(field)
        idx(field) = field
      ENDDO
      CLOSE (1)
      DO j=1,NRING
        IF (survey(j).eq.1) THEN
          DO i=frst(j),last(j)
            jzone(i) = j
            zone(i) = ring(j)
          ENDDO
        ENDIF
      ENDDO
      CALL iuqsrt(NPOSS1,bcd,idx)
      CALL ireord(NPOSS1,idx,rcd,tmp)
      CALL ireord(NPOSS1,idx,zone,tmp)
      CALL ireord(NPOSS1,idx,jzone,tmp)
      DO i=1,NPOSS1
        IF ((idx(i).ne.OMIT).and.(idx(i).le.NP1KEEP)) THEN
          WRITE (2,9005) idx(i),jzone(i),zone(i),bcd(i),rcd(i)
        ENDIF
      ENDDO
c
c...Load SRC
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='../../binary/cddir/sscd.dir',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9001) ncolor,nfield
      DO field=1,nfield
        READ (1,9002) nlb,lb
        bfn(field) = lb
        bnfn(field) = nlb
        READ (lb(1:nlb),9003) bcd(field)
        READ (1,9002) nlb,lb
        rfn(field) = lb
        rnfn(field) = nlb
        READ (lb(1:nlb),9003) rcd(field)
        idx(field) = field
        READ (1,9002)
      ENDDO
      CLOSE (1)
      DO j=1,NRING
        IF (survey(j).eq.3) THEN
          DO i=frst(j),last(j)
            jzone(i) = j
            zone(i) = ring(j)
          ENDDO
        ENDIF
      ENDDO
      CALL iuqsrt(NSRC,bcd,idx)
      CALL ireord(NSRC,idx,rcd,tmp)
      CALL ireord(NSRC,idx,zone,tmp)
      CALL ireord(NSRC,idx,jzone,tmp)
      DO i=NSRC,1,-1
        WRITE (2,9005) idx(i),jzone(i),zone(i),bcd(i),rcd(i)
      ENDDO
c
c...All Done
c
      CLOSE (2)
      CALL EXIT
      END
