      SUBROUTINE  getccd(n,xx,yy,qq,ccdx,ccdy)
c
c...Compute True CCD Pixel Location
c
      INCLUDE
     *            'ugap012.inc'
      PARAMETER
     *            tol = 2,
     *            itmax = 5
      INTEGER
     *            px, py, mm, ixl, iyl, ihx, ihy, ixt, iyt, ix, iy,
     *            i, j, rx, ry, iter, nfail, n, xx(*), yy(*), qq(*)
      REAL
     *            xl, yl, hx, hy, xn, xd, yn, yd, fx, fy, x, y,
     *            qx, qy, ccdx(*), ccdy(*)
c
 9001 FORMAT (' GETCCD N(fail)=', i10)
c
c...Crack CCD Pixel Coordinates And Create Fake X,Y
c
  100 nfail = 0
      DO i=1,n
        j = qq(i)
        mm = j/NPIXELS
        j = j - mm*NPIXELS
        py = j/NCOLS
        px = j - py*NCOLS
        ixt = xx(i)
        iyt = yy(i)
c
c...Assume Truncated Part Was 0
c
        xl = px+0.5
        yl = py+0.5
        qx = xl
        qy = yl
        CALL dzapply(qx,qy)
        CALL scapply(mm,qx,qy,ixl,iyl)
c
c...Assume Truncated Part Was 1
c
        hx = px+1.5
        hy = py+1.5
        qx = hx
        qy = hy
        CALL dzapply(qx,qy)
        CALL scapply(mm,qx,qy,ihx,ihy)
c
c...See How To Improve
c
        iter = 0
  110   iter = iter+1
        xn = ixt-ixl
        xd = ihx-ixl
        fx = xn/xd
        yn = iyt-iyl
        yd = ihy-iyl
        fy = yn/yd
        x = xl + fx*(hx-xl)
        y = yl + fy*(hy-yl)
        qx = x
        qy = y
        CALL dzapply(qx,qy)
        CALL scapply(mm,qx,qy,ix,iy)
        rx = ix-ixt
        ry = iy-iyt
        IF (ix.gt.ixt) THEN
          hx = x
          ihx = ix
        ELSE
          xl = x
          ixl = ix
        ENDIF
        IF (iy.gt.iyt) THEN
          hy = y
          ihy = iy
        ELSE
          yl = y
          iyl = iy
        ENDIF
        IF (iter.le.ITMAX) THEN
          IF ((ihx.ne.ixl).and.(ihy.ne.iyl)) THEN
            IF ((ABS(rx).gt.TOL).or.(ABS(ry).gt.TOL)) GO TO 110
          ENDIF
        ELSE
          nfail = nfail+1
        ENDIF
c
c...Save The Answer
c
        ccdx(i) = x
        ccdy(i) = y
        qq(i) = mm
      ENDDO
      WRITE (*,9001) nfail
      WRITE (10,9001) nfail
      RETURN
      END
