      SUBROUTINE  oepairs(id,np,p1,p2,
     *                     n1,x1,y1,m1,
     *                     n2,x2,y2,m2, tmp,ps,who,err)
c
c...Combine Each Pair
c
      INCLUDE
     *            'ugap012.inc'
      PARAMETER
     *            billion = 1000*1000*1000,
     *            million = 1000*1000,
     *            thousand = 1000,
     *            half = 180*3600*100,
     *            circle = half+half
      INTEGER
     *            np, p1(*), p2(*), n1, x1(*), y1(*), m1(*), n2, x2(*),
     *            y2(*), m2(*), tmp(*), err, i, i1, i2, x, y, dx, dy,
     *            mbad, mag1, mag2, ps(*), id, bad1, bad2, msign,
     *            bonly, ronly, both, bit1, bit2, who, set1, set2
      DOUBLE PRECISION
     *            sx, sxx, sy, syy, sd, cd
c
 9001 FORMAT (' O+E F=', i3, '  NP=', i7, '  X=', f6.2, '+/-', f5.2,
     *        '  Y=', f6.2, '+/-', f5.2, ' arcsec')
 9003 FORMAT (' OEPAIRS  N(bad1)=', i6, '  N(bad2)=', i6)
 9004 FORMAT (' OEPAIRS N(both)=', i6, '  N(1)=', i6, '  N(2)=', i6,
     *        '  N(total)=', i6)
c
c...Initialization
c
  100 sx = 0.0D00
      sy = 0.0D00
      sxx = 0.0D00
      syy = 0.0D00
      sd = 0.0D00
      bad1 = 0
      bad2 = 0
      bonly = 0
      ronly = 0
      both = 0
      set1 = 0
      set2 = 0
c
c...Process Each Pair
c
      DO i=1,np
        i1 = p1(i)
        i2 = p2(i)
c
c...Take Mean
c
        x = (x1(i1)+x2(i2)+1)/2
        dx = x1(i1)-x2(i2)
        y = (y1(i1)+y2(i2)+1)/2
        dy = y1(i1)-y2(i2)
        IF (dx.lt.-HALF) THEN
          dx = dx+CIRCLE
          IF (x.ge.HALF) THEN
            x = x-HALF
          ELSE
            x = x+HALF
          ENDIF
        ELSEIF (dx.gt.HALF) THEN
          dx = dx-CIRCLE
          IF (x.ge.HALF) THEN
            x = x-HALF
          ELSE
            x = x+HALF
          ENDIF
        ENDIF
c
c...Debugging.  Who Should We Believe?
c
        x1(i1) = x
        y1(i1) = y
 9999   CONTINUE
c
        sx = sx + dx
        sxx = sxx + dx*dx
        sy = sy + dy
        syy = syy + dy*dy
        sd = sd + y
c
c...Pack TMP To Save Residuals
c
        dx = MAX(0,MIN(9999,dx+5000))
        dy = MAX(0,MIN(9999,dy+5000))
        tmp(i) = dy*10000+dx
c
c...Pack The Magnitudes To Indicate That This Is A Pair
c
c	The BAD flag gets set if either M_B or M_R failed the test
c	in TAGMAG.F for the ratio of n_sat/n_in.  This status was
c	reported by BIT_A.
c
c	The SIGN gets set if either the B or R image was correlated
c	with an ACT entry.  BIT_B is set for the blue magnitude, and
c	BIT_C is set for the red magnitude.
c
        mbad = 0
        IF ((AND(m1(i1),BIT_A).ne.0).or.(AND(m2(i2),BIT_A).ne.0)) THEN
          mbad = BILLION
          m1(i1) = AND(m1(i1),NOT(BIT_A))
          m2(i2) = AND(m2(i2),NOT(BIT_A))
        ENDIF
        msign = 1
        bit1 = AND(m1(i1),BIT_B)
        m1(i1) = AND(m1(i1),NOT(BIT_B))
        bit2 = AND(m2(i2),BIT_C)
        m2(i2) = AND(m2(i2),NOT(BIT_C))
        IF (bit1.ne.0) THEN
          msign = -1
          IF (bit2.ne.0) THEN
            both = both+1
          ELSE
            set1 = set1+1
          ENDIF
        ELSE
          IF (bit2.ne.0) THEN
            msign = -1
            set2 = set2+1
          ENDIF
        ENDIF
        IF ((m1(i1).lt.0).or.(m1(i1).gt.9999)) THEN
          bad1 = bad1+1
          m1(i1) = MOD(m1(i1),10000)
          IF (m1(i1).lt.0) THEN
            m1(i1) = m1(i1)+10000
          ENDIF
        ENDIF
        IF ((m2(i2).lt.0).or.(m2(i2).gt.9999)) THEN
          bad2 = bad2+1
          m2(i2) = MOD(m2(i2),10000)
          IF (m2(i2).lt.0) THEN
            m2(i2) = m2(i2)+10000
          ENDIF
        ENDIF
        mag1 = (5+m1(i1))/10
        mag1 = MAX(1,MIN(999,mag1))
        mag2 = (5+m2(i2))/10
        mag2 = MAX(1,MIN(999,mag2))
        m1(i1) = msign*(mbad + id*MILLION + mag1*THOUSAND + mag2)
      ENDDO
      IF ((bad1.gt.0).or.(bad2.gt.0)) THEN
        WRITE (*,9003) bad1,bad2
        WRITE (10,9003) bad1,bad2
      ENDIF
      i = both+set1+set2
      WRITE (*,9004) both,set1,set2,i
      WRITE (10,9004) both,set1,set2,i
c
c...Scribble TMP For Debugginb
c
      CALL saveres(who,id,np,tmp)
c
c...Fill M2/TMP With Original Record Number
c
      DO i=1,n1
        m2(i) = 0
        tmp(i) = 0
      ENDDO
      DO i=1,np
        i1 = p1(i)
        i2 = p2(i)
        m2(i1) = i1
        tmp(i1) = i2
      ENDDO
c
c...Do Statistics To Reassure The User
c
      sx = sx/np
      sxx = SQRT(sxx/np - sx*sx)
      sy = sy/np
      syy = SQRT(syy/np - sy*sy)
      sd = sd/np
      cd = COSD(sd/360000.0D00 - 90.0D00)
      sx = sx*cd
      sxx = sxx*cd
      ps( 5) = sx
      ps( 6) = sxx
      ps( 7) = sy
      ps( 8) = syy
      sx = 0.01D00*sx
      sy = 0.01D00*sy
      sxx = 0.00717D00*sxx
      syy = 0.00717D00*syy
      WRITE ( *,9001) id,np,sx,sxx,sy,syy
      WRITE (10,9001) id,np,sx,sxx,sy,syy
      err = 0
      RETURN
      END
