      SUBROUTINE  intersect(c1,c2,fn)
c
c...Solve For Intersections Of Lines
c
      INCLUDE
     *            'ugapea.inc'
      PARAMETER
     *            nominal = 12.0D00
      CHARACTER*(*)
     *            fn
      DOUBLE PRECISION
     *            c1(4,NMAX), c2(6,NMAX), b21, a12, x, yb, yf, y,
     *            a, b, c, r1, r2, s1, s2, d
      INTEGER
     *            i, j
c
 9001 FORMAT (i5, 2f10.2, 5f10.5)
 9002 FORMAT (' Ooops', i5, 2(1x,1pe10.3))
 9003 FORMAT (i5, 2(1x,1pe10.3))
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=fn,
     *      status='unknown',
     *      unit=1
     *     )
      DO i=1,NMAX
        DO j=1,4
          IF (c1(j,i).eq.TAG) GO TO 110
        ENDDO
        DO j=1,6
          IF (c2(j,i).eq.TAG) GO TO 110
        ENDDO
        a = c2(3,i)
        b = c2(2,i)-c1(2,i)
        c = c2(1,i)-c1(1,i)
        d = b*b - 4.0D00*a*c
        IF ((d.lt.0.0D00).or.(a.eq.0.0D00)) THEN
          WRITE (*,9002) i,d,a
          OPEN (
     *          access='append',
     *          carriagecontrol='list',
     *          dispose='keep',
     *          form='formatted',
     *          name='ugapd0.err',
     *          status='unknown',
     *          unit=2
     *         )
          WRITE (2,9002) i,d,a
          CLOSE (2)
          GO TO 110
        ELSE
          d = SQRT(d)
          r1 = (-b + d)/(a+a)
          r2 = (-b - d)/(a+a)
          s1 = ABS(r1-NOMINAL)
          s2 = ABS(r2-NOMINAL)
          IF (s1.lt.s2) THEN
            x = r1
          ELSE
            x = r2
          ENDIF
          y = c1(1,i) + x*c1(2,i)
        ENDIF
        WRITE (1,9001) i,x,y,c1(1,i),c1(2,i),c2(1,i),c2(2,i),c2(3,i)
  110   CONTINUE
      ENDDO
      CLOSE (1)
      RETURN
      END
