      PROGRAM  ugapeg
c
c...Fix Non-Intersections
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nloop = 4,
     *         nvect = 7
      CHARACTER*10
     *         fin, fout
      DOUBLE PRECISION
     *         vect(NVECT), toofaint(NLOOP), yfaint, bright(NLOOP),
     *         ybright, xfaint, xbright, slope, offset
      INTEGER
     *         loop, i, id, nfix
      DATA
     *         toofaint/13.5D00, 12.7D00, 14.3D00, 14.6D00/,
     *           bright/10.0D00, 10.0D00, 10.0D00, 10.0D00/
c
 9001 FORMAT (i5, 2f10.2, 5f10.5)
 9002 FORMAT (' File=', a, '  Fixed ', i2)
c
c...Outer Loop
c
  100 DO loop=1,NLOOP
        IF (loop.eq.1) THEN
          fin = 'nbtruth.98'
        ELSEIF (loop.eq.2) THEN
          fin = 'sbtruth.98'
        ELSEIF (loop.eq.3) THEN
          fin = 'nrtruth.98'
        ELSE
          fin = 'srtruth.98'
        ENDIF
        fout = fin
        fout(10:10) = '9'
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name=fin,
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name=fout,
     *        status='unknown',
     *        unit=2
     *       )
c
c...Inner Loop Reads And Fixes (If Necessary)
c
        nfix = 0
  110   READ (1,9001,end=120) id,(vect(i),i=1,NVECT)
        IF (vect(1).gt.toofaint(loop)) THEN
          xfaint = toofaint(loop)
          yfaint = vect(5) + vect(6)*xfaint + vect(7)*xfaint*xfaint
          xbright = bright(loop)
          ybright = vect(3) + vect(4)*xbright
          slope = (yfaint-ybright)/(xfaint-xbright)
          offset = ybright - slope*xbright
          vect(3) = offset
          vect(4) = slope
          vect(1) = xfaint
          vect(2) = yfaint
          nfix = nfix+1
        ENDIF
        WRITE (2,9001) id,(vect(i),i=1,NVECT)
        GO TO 110
  120   CLOSE (1)
        CLOSE (2)
        WRITE (*,9002) fin,nfix
      ENDDO
      CALL EXIT
      END
