      PROGRAM  getcenters
c
c...Read The SLA Files To Porduce A List Of Field Centers For SELECT
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         np1 = 937,
     *         nss = 606,
     *         nmax = (np1+nss),
     *         nrcom = 74,
     *         field_ora = 27,
     *         field_odec = 28
      DOUBLE PRECISION
     *         rcom(NRCOM), radian
      INTEGER
     *         i, j, nlb, nfn, survey, ira, ispd
      CHARACTER*64
     *          lb, fn
      CHARACTER*1
     *          c
c
 9001 FORMAT ('AUXTYC:auxtyc', a, '/ot', i4.4, '.sla')
 9002 FORMAT ('AUXTYC:auxtyc', a, '/bt', i4.4, '.sla')
 9003 FORMAT (7i11)
c
c...Initialization
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='centers.dat',
     *      status='unknown',
     *      unit=1
     *     )
      WRITE (1,9003) NP1,NSS
      radian = 45.0D00/ATAN(1.0D00)
c
c...Process POSS-I
c
      survey = 1
      DO i=1,NP1
        j = i/100
        IF (i.le.999) THEN
          c = CHAR(ICHAR('0')+j)
        ELSE
          c = 'z'
        ENDIF
        WRITE (lb,9001) c,i
        nlb = 25
        CALL f_doenv(lb(1:nlb),nfn,fn)
        OPEN (
     *        access='direct',
     *        carriagecontrol='none',
     *        convert='big_endian',
     *        dispose='keep',
     *        form='unformatted',
     *        name=fn(1:nfn),
     *        readonly,
     *        recl=(2*NRCOM),
     *        recordtype='fixed',
     *        shared,
     *        status='old',
     *        unit=2
     *       )
        READ (2,rec=1) rcom
        CLOSE (2)
        ira = rcom(FIELD_ORA)*radian*360000.0D00
        ispd = (rcom(FIELD_ODEC)*radian + 90.0D00)*360000.0D00
        WRITE (1,9003) i,survey,ira,ispd
      ENDDO
c
c...Process Southern Surveys
c
      survey = 3
      DO i=1,NSS
        j = i/100
        c = CHAR(ICHAR('a')+j)
        WRITE (lb,9002) c,i
        nlb = 25
        CALL f_doenv(lb(1:nlb),nfn,fn)
        OPEN (
     *        access='direct',
     *        carriagecontrol='none',
     *        convert='big_endian',
     *        dispose='keep',
     *        form='unformatted',
     *        name=fn(1:nfn),
     *        readonly,
     *        recl=(2*NRCOM),
     *        recordtype='fixed',
     *        shared,
     *        status='old',
     *        unit=2
     *       )
        READ (2,rec=1) rcom
        CLOSE (2)
        ira = rcom(FIELD_ORA)*radian*360000.0D00
        ispd = (rcom(FIELD_ODEC)*radian + 90.0D00)*360000.0D00
        WRITE (1,9003) i,survey,ira,ispd
      ENDDO
c
c...All Done
c
      CLOSE (1)
      CALL EXIT
      END
