      SUBROUTINE  looper(zone)
c
c...Loop Over ZONE File Chunk At A Time
c
      INCLUDE
     *            'ugap6.inc'
      INTEGER
     *            ntotal, nmost, nlast, nchunk, i, n, err, fd, j, l, k,
     *            C_ROOPEN, C_READER, nl, nt, x1, x2, x3, zone, k1, k2
      BYTE
     *            bb(65)
c
 9001 FORMAT (' Read Error ', i12)
 9002 FORMAT (' Cannot Open ', a)
 9003 FORMAT (' Checks', 4i12)
 9004 FORMAT (' Chunk ', i2, ' Of ', i2)
 9005 FORMAT (' Zone ', i4, '  NTOT=', i12)
 9007 FORMAT (' TAG Removal N', 2i12)
c
c...Set Up Loop Parameters
c
  100 ntotal = ff(NRA) + ll(NRA) - 1
      WRITE (*,9005) zone,ntotal
      WRITE (3,9005) zone,ntotal
      nchunk = ((ntotal-1)/NMAX) + 1
      nmost = NMAX
      nlast = ntotal - ((nchunk-1)*nmost)
      root(nroot-2:nroot) = 'cat'
      DO i=1,nroot
        bb(i) = ICHAR(root(i:i))
      ENDDO
      bb(nroot+1) = 0
      fd = C_ROOPEN(bb)
      IF (fd.le.2) THEN
        WRITE (*,9002) root(1:nroot)
        WRITE (3,9002) root(1:nroot)
        CALL EXIT
      ENDIF
      nl = 0
      nt = 0
c
c...Loop
c
      DO j=1,nchunk
        WRITE (*,9004) j,nchunk
        WRITE (3,9004) j,nchunk
        IF (j.eq.nchunk) THEN
          n = nlast
        ELSE
          n = nmost
        ENDIF
        rfrst = 1
        rlast = n
        tfrst = (j-1)*nmost + 1
        tlast = tfrst + n - 1
        err = C_READER(fd,buf,5*4*n)
        IF (err.ne.0) THEN
          WRITE (*,9001) err
          WRITE (3,9001) err
          CALL EXIT
        ENDIF
c
c...Apply The Tags
c
        DO i=1,ntag
          l = tag(i)
          IF ((l.ge.tfrst).and.(l.le.tlast)) THEN
            buf(3,l+1-tfrst) = TAGVAL
            nt = nt+1
          ENDIF
        ENDDO
c
c...Remove The TAGged Entries
c
        nobuf = 0
        DO i=1,n
          IF (buf(3,i).ne.TAGVAL) THEN
            nobuf = nobuf+1
            buf(1,nobuf) = buf(1,i)
            buf(2,nobuf) = buf(2,i)
            buf(3,nobuf) = buf(3,i)
            buf(4,nobuf) = buf(4,i)
            buf(5,nobuf) = buf(5,i)
          ENDIF
        ENDDO
        WRITE (*,9007) n,nobuf
        WRITE (3,9007) n,nobuf
c
c...End Of Loop
c
        CALL saveit
      ENDDO
      CALL c_closer(fd)
      WRITE (*,9003) ntag,nt
      WRITE (3,9003) ntag,nt
      RETURN
      END
