      PROGRAM  ugap7k
c
c Create FITS file representing a sky map with in global
c sinusoidal coordinates and shaded according to input density list.
c
c This version makes a weighted average of value of nearest 3 points
c
c Author:  Blaise Canzian 3/14/96
c
c Hacks By D. Monet 12 Aug 96
c
      implicit none
      real*4 TOL
      integer*4 NX, NY, MXPTS, PLANEPTS, ROTATE, SLIDE
      parameter (NX=1440, NY=720, MXPTS=4000, PLANEPTS=3, TOL=1.e-6 )
      integer*4 imap(NX,NY), kx, ky, i1, i2, j1, j2, nstep, frst, xj
      real*4 z, wide, sum, check(NX)
      parameter (ROTATE=720, SLIDE=0)
c
      real*4 amap(-NX/2:NX/2,-NY/2:NY/2), alpha(MXPTS), delta(MXPTS),
     & density(MXPTS), x(MXPTS), y(MXPTS), d2r, dist(PLANEPTS), r,
     & xymap(NX+1,NY+1), sumwt, sumdat, xx, yy, f1, f2, f3, f4
      integer*4 ix, jy, npts, idist(PLANEPTS), i,j,k
      logical inside
      character aline*80, infile*80, outfile*80, ans*1
c
  1   format(a)
  2   format(t1,(a),$)
  3   format(t1,(a))
c
      write(6,5) 'S K Y D E N S',
     & 'Write FITS file of density on an all-sky map'
  5   format(/t34,(a)/t19,(a)/)
c
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name='ugap7j.dat',
     *      readonly,
     *      recl=(NX*NY),
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1) imap
      CLOSE (1)
      DO j=1,NY+1
        DO i=1,NX+1
          xymap(i,j) = 0.0
        ENDDO
      ENDDO
      DO j=1,NY
        xj = j+SLIDE
        IF (xj.lt.1) THEN
          xj = xj+NY
        ELSEIF (xj.gt.NY) THEN
          xj = xj-NY
        ENDIF
        yy = 0.25*j - 0.125*(NY+1)
        nstep = NX*COSD(yy)
        IF (MOD(nstep,2).eq.0) THEN
          nstep = nstep+1
        ENDIF
        wide = NX
        wide = wide/nstep
        frst = NX/2 - (nstep+1)/2
        DO i=1,NX
          check(i) = 0.0
        ENDDO
        DO i=1,nstep
          z = (i-1)*wide
          i1 = z
          f1 = z-i1
          z = i*wide
          i2 = z
          f2 = z-i2
          sum = 0.0
          DO k=i1,i2
            j1 = k + (ROTATE+1)
            IF (j1.le.0) THEN
              j1 = j1+NX
            ELSEIF (j1.gt.NX) THEN
              j1 = j1-NX
            ENDIF
            IF (k.eq.i1) THEN
              sum = sum + (1.0-f1)*imap(j1,xj)
              check(j1) = check(j1) + (1.0-f1)
            ELSEIF (k.eq.i2) THEN
              sum = sum + f2*imap(j1,xj)
              check(j1) = check(j1) + f2
            ELSE
              sum = sum + imap(j1,xj)
              check(j1) = check(j1) + 1.0
            ENDIF
          ENDDO
          xymap(frst+i,j) = sum
        ENDDO
      ENDDO
      k = 0
      xx = 0
      DO j=1,NY+1
        DO i=1,NX+1
          IF (xymap(i,j).ne.0) THEN
            k = k+1
            xx = MAX(xx,xymap(i,j))
          ENDIF
        ENDDO
      ENDDO
      write (*,9993) k,xx
 9993 format (' Checking ', i10, f10.1)
              
c...write FITS file
  41  outfile = 'ugap7j.fits'
      call writfits(xymap,NX+1,NY+1,12,outfile)
c
      end
c
c Is the point (x,y) inside the skymap area?  Assume degrees are units.
c
      logical function inside(x,y)
c
      real*4 x, y, xmn, xmx
c
      xmn = -180.0*cosd(y)
      xmx = 180.0*cosd(y)
      if( xmn.le.x .and. x.le.xmx ) then
         inside = .true.
      else
         inside = .false.
      end if
      return
      end
c
c
c
      subroutine writfits(xymap,nx,ny,iunit,fname)
c
c FITS writer to use on DEC Unix machines.  The data is
c assumed to have at most 1048576 elements (1024x1024).  The FITS file is
c written with pixel indexing which corresponds to AIPS [LLHC = (1,1) and
c X increasing to the right, Y increasing to the top].
c
c
      implicit none
      integer maxpix, MAXNX, MAXNY
      parameter( MAXNX=1441, MAXNY=721, maxpix=MAXNX*MAXNY )
c
      real*8 bzero, bscale, dtest
      real amap(maxpix), ymin, ymax, range, temp, xymap(MAXNX,MAXNY)
      integer ierr, bitpix, bytpix, ipix, pixrec, items, npix, npixleft,
     & iline, recnum, nx, ny, iunit
      integer*2 buffw(1440), wzero
      integer*4 mapdm(10), buffl(720), naxis, two31, two15, lzero, itfn,
     *          i, j
      character header*2880, fname*80, aline*80, tname*9
      logical thirtytwo, aips
      byte buffer(2880)
      equivalence( buffer, buffw, buffl )
      parameter( two31 = 2147483647 )
      parameter( two15 = 32767 )
c
  1   format( a )
  2   format( t4, (a), $ )
  3   format( t4, (a) )
  4   format( t4, (a), i4 )
c
      open(unit=iunit,file=fname,form='unformatted',recl=720,
     & access='direct',status='unknown',err=110)
      goto 12
c
c Apparently, Ultrix Fortran specifies records in 4-byte chunks.
c Hence, divide 2880 by 4 to get "recl=720" above.
c
c     open( unit=12, file=outfile, form='unformatted', recl=2880,
c    & access='direct', status='new', err=15 )
110   tname = 'temp0.fts'
      itfn = 0
111   open(unit=iunit,file=tname,form='unformatted',recl=720,
     & access='direct',status='new',err=112)
      write(6,3) 'Could not open '//fname//' opening '//tname//
     *           ' instead'
      goto 12
112   itfn = itfn + 1
      write(tname(5:5),113) itfn
113   format(i1)
      goto 111
 12   naxis = 2
      aips = .false.
      bitpix = 16
      thirtytwo = .false.
c
      mapdm(1) = nx
      mapdm(2) = ny
      npix = nx*ny
      if( npix .gt. MAXNX*MAXNY ) then
         write(6,3) 'Map too big.'
         close(iunit)
         go to 99
      end if
c
c Write a 1-D array from the 2-D input
c
      do j=1,ny
         do i=1,nx
            amap(nx*(j-1) + i) = xymap(nx+1-i,j)
         end do
      end do
c
c Write header with only the bare minimum of information.
c
      header = ' '
      aline = ' '
      iline = 0
      aline(1:6) = 'SIMPLE'
      aline(9:9) = '='
      aline(30:30) = 'T'
      aline(32:32) = '/'
      do j=1,80
         header(80*iline+j:80*iline+j) = aline(j:j)
      end do
      aline = ' '
      iline = 1
      aline(1:6) = 'BITPIX'
      aline(9:9) = '='
      if( thirtytwo ) then
         aline(29:30) = '32'
      else
         aline(29:30) = '16'
      end if
      aline(32:32) = '/'
      do j=1,80
         header(80*iline+j:80*iline+j) = aline(j:j)
      end do
      iline = 2
      aline = ' '
      aline(1:5) = 'NAXIS'
      aline(9:9) = '='
      write( aline(28:30), 22 ) naxis
 22   format( i3 )
      aline(32:32) = '/'
      do j=1,80
         header(80*iline+j:80*iline+j) = aline(j:j)
      end do
      do i=1,naxis
         aline = ' '
         aline(1:5) = 'NAXIS'
         aline(9:9) = '='
         write( aline(6:6), 23 ) i
 23      format( i1 )
         write( aline(11:30), * ) mapdm(i)
         aline(32:32) = '/'
         iline = iline + 1
         do j=1,80
            header(80*iline+j:80*iline+j) = aline(j:j)
         end do
      end do
c
      ymin = amap(1)
      ymax = amap(1)
      do i=2,npix
         ymin = min( ymin, amap(i) )
         ymax = max( ymax, amap(i) )
      end do
      bzero = 5.0d-1*(dble(ymax) + dble(ymin))
      range = 0.5*(ymax - ymin)
      if( thirtytwo ) then
         bscale = dble( range )/dble( two31 )
      else
         bscale = dble( range )/dble( two15 )
      end if
      lzero = -two31 - 1
      wzero = -two15 - 1
c     lzero = int( (dble(ymin) - bzero)/bscale )
c     wzero = int( (dble(ymin) - bzero)/bscale )
c
      iline = iline + 1
      aline = ' '
      aline(1:5) = 'BZERO'
      aline(9:9) = '='
      write( aline(11:30), 31 ) bzero
 31   format( g20.12 )
      aline(32:32) = '/'
      do j=1,80
         header(80*iline+j:80*iline+j) = aline(j:j)
      end do
c
      iline = iline + 1
      aline = ' '
      aline(1:6) = 'BSCALE'
      aline(9:9) = '='
      write( aline(11:30), 31 ) bscale
      aline(32:32) = '/'
      do j=1,80
         header(80*iline+j:80*iline+j) = aline(j:j)
      end do
c
      iline = iline + 1
      aline = ' '
      aline(1:3) = 'END'
      aline(32:32) = '/'
      do j=1,80
         header(80*iline+j:80*iline+j) = aline(j:j)
      end do
c
      recnum = 1
      write( unit=iunit, rec=recnum, iostat=ierr ) header
      if( ierr .ne. 0 ) then
         write(6,4) 'Write error #', ierr
         write(6,3) 'Probably not enough disk space.'
         close(iunit)
         go to 99
      end if
c
      bytpix = bitpix/8
      ipix = 0
      pixrec = 2880/bytpix
      npixleft = npix
      do while( npixleft .gt. 0 )
         recnum = recnum + 1
         items = min( npixleft, pixrec )
         if( thirtytwo ) then
            do i=1,items
               ipix = ipix + 1
c              buffl(i) = int( (dble(amap(ipix)) - bzero)/bscale )
               dtest = (dble(amap(ipix)) - bzero)/bscale
               if( dtest .ge. dble(two31) ) then
                  buffl(i) = two31
               else if( dtest .lt. -dble(two31) ) then
                  buffl(i) = -two31 - 1
               else
                  buffl(i) = int(dtest)
               end if
            end do
            if( items .lt. pixrec ) then
               do i=items+1,pixrec
                  buffl(i) = lzero
               end do
            end if
         else
            do i=1,items
               ipix = ipix + 1
c              buffw(i) = int( (dble(amap(ipix)) - bzero)/bscale )
               dtest = (dble(amap(ipix)) - bzero)/bscale
               if( dtest .ge. dble(two15) ) then
                  buffw(i) = two15
               else if( dtest .lt. -dble(two15) ) then
                  buffw(i) = -two15 - 1
               else
                  buffw(i) = int(dtest)
               end if
            end do
            if( items .lt. pixrec ) then
               do i=items+1,pixrec
                  buffw(i) = wzero
               end do
            end if
         end if
c
c Byte swapping for DEC
c
         if( bitpix .eq. 16 ) then
            call fits_bswap(buffl,2880)
         else if( bitpix .eq. 32 ) then
            call fits_lbswap(buffw,2880)
         else
            write(6,3) 'Bits per pixel not 16 or 32.'
            goto 99
         end if
c
         write( unit=iunit, rec=recnum, iostat=ierr ) buffer
         if( ierr .ne. 0 ) then
            write(6,4) 'Write error #', ierr
            write(6,3) 'Probably not enough disk space.'
            close(iunit)
            go to 99
         end if                   
         npixleft = npixleft - pixrec
      end do
c
      close(iunit)
 99   end
c
c Subroutines to byte swap.  Modified from code by Jeff Pier.
c
	subroutine fits_bswap (input,num_bytes)
c
        implicit none
c
        integer num_bytes, i
	byte input(*), tempo
c
c swap pairs of bytes:
c
	do i=1,num_bytes/2
	    tempo = input(2*i-1)
	    input(2*i-1) = input(2*i)
	    input(2*i) = tempo
	enddo
c
	return
	end
c
c
c
	subroutine fits_lbswap (input,num_bytes)
c
        implicit none
c
        integer num_bytes, i
	byte input(*), tempo
c
c swap quartets of bytes:
c
	do i=1,num_bytes/4
	    tempo = input(4*(i-1)+4)
	    input(4*(i-1)+4) = input(4*(i-1)+1)
	    input(4*(i-1)+1) = tempo
	    tempo = input(4*(i-1)+2)
	    input(4*(i-1)+2) = input(4*(i-1)+3)
	    input(4*(i-1)+3) = tempo
	enddo
c
	return
	end
c
c
c
      SUBROUTINE NR_SORT2(N,RA,IB)
      IMPLICIT NONE
      INTEGER  N, IB(N), L, IR, I, J, IRB
      REAL*4 RA(N), RRA
      L=N/2+1
      IR=N
10    CONTINUE
        IF(L.GT.1)THEN
          L=L-1
          RRA=RA(L)
          IRB=IB(L)
        ELSE
          RRA=RA(IR)
          IRB=IB(IR)
          RA(IR)=RA(1)
          IB(IR)=IB(1)
          IR=IR-1
          IF(IR.EQ.1)THEN
            RA(1)=RRA
            IB(1)=IRB
            RETURN
          ENDIF
        ENDIF
        I=L
        J=L+L
20      IF(J.LE.IR)THEN
          IF(J.LT.IR)THEN
            IF(RA(J).LT.RA(J+1))J=J+1
          ENDIF
          IF(RRA.LT.RA(J))THEN
            RA(I)=RA(J)
            IB(I)=IB(J)
            I=J
            J=J+J
          ELSE
            J=IR+1
          ENDIF
        GO TO 20
        ENDIF
        RA(I)=RRA
        IB(I)=IRB
      GO TO 10
      END
