      SUBROUTINE  doeach(nn,xx,yy,tt, nc,cc,sc,sg)
c
c...Fit Each Field
c
      INCLUDE
     *            'ugapb.inc'
      INTEGER
     *            nn, xx(*), yy(*), tt(*), nc, i, j, k, ising, m
      DOUBLE PRECISION
     *            cc(*), sc(*), sg, yc, yr, chisq, x, y
c
 9001 FORMAT (' Singular Matrix In DOEACH')
c
c...Initialization
c
  100 DO i=1,nc
        zlhs(i) = 0.0D00
        cc(i) = 0.0D00
        sc(i) = -1.0D00
        DO j=1,nc
          zrhs(i,j) = 0.0D00
        ENDDO
      ENDDO
      chisq = 0.0D00
      sg = -1.0D00
      m = 0
c
c...Accumulation
c
      DO i=1,nn
        IF (tt(i).ne.0) THEN
          x = 0.1D00*xx(i)
          y = 0.01D00*yy(i)
          dv(1) = 1.0D00
          DO j=2,nc
            dv(j) = dv(j-1)*x
          ENDDO
          DO j=1,nc
            zlhs(j) = zlhs(j) + dv(j)*y
            DO k=1,nc
              zrhs(j,k) = zrhs(j,k) + dv(j)*dv(k)
            ENDDO
          ENDDO
          m = m+1
        ENDIF
      ENDDO
c
c...Inversion
c
      CALL matinv(nc,ising)
      IF (ising.ne.0) THEN
        WRITE (*,9001)
        RETURN
      ENDIF
c
c...Coefficients
c
      DO i=1,nc
        DO j=1,nc
          cc(i) = cc(i) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Residuals And ChiSquared
c
      DO i=1,nn
        x = 0.1D00*xx(i)
        y = 0.01D00*yy(i)
        dv(1) = 1.0D00
        DO j=2,nc
          dv(j) = dv(j-1)*x
        ENDDO
        yc = 0.0D00
        DO j=1,nc
          yc = yc + cc(j)*dv(j)
        ENDDO
        yr = y-yc
        IF (tt(i).ne.0) THEN
          chisq = chisq + yr*yr
        ENDIF
        tt(i) = 100.0D00*yr
      ENDDO
c
c...Errors
c
      sg = SQRT(chisq/(m-(nc+1)))
      DO i=1,nc
        sc(i) = sg*SQRT(zrhs(i,i))
      ENDDO
      RETURN
      END
