      PROGRAM  fitexam
c
c...Look At The Fits
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nsurvey = 4,
     *         nbin = 10,
     *         s0 = 1.0,
     *         sc = 1.0,
     *         nmax = 1000
      INTEGER
     *         i, j, color, field, nin, sigma, ntotal, nsat, nbad,
     *         low(NSURVEY), high(NSURVEY), hist(NBIN,NSURVEY)
      REAL
     *         offset, slope, xmin, xmax, ymin, ymax, xbin(NBIN),
     *         ybin(NBIN), y
c
 9001 FORMAT (' S=', i1, '  Low=', i5, '  High=', i5)
 9002 FORMAT (i1, 2(1x,i5), 1x,f5.2, 2(1x,i5), 2(1x,1pe11.4))
 9003 FORMAT (3(1x,i5), 1x, f10.3)
c
c...Initialization
c
  100 DO j=1,NSURVEY
        DO i=1,NBIN
          hist(i,j) = 0
        ENDDO
        low(j) = 0
        high(j) = 0
      ENDDO
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='ugapb.fit',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='fitexam.out',
     *      status='unknown',
     *      unit=2
     *     )
c
c...Parse Each Line And Save The Slope
c
  110 READ (1,9002,end=120) color,field,nin,sigma,ntotal,nsat,
     *                      offset,slope
      IF (nin.le.0) THEN
        nbad = nbad+1
        WRITE (2,9003) color,field,nin
      ELSE
        IF (field.lt.2000) THEN
          j = 1
        ELSE
          j = 3
        ENDIF
        IF (color.ne.0) THEN
          j = j+1
        ENDIF
        i = (slope-S0)/SC + 1.0
        IF (i.lt.1) THEN
          low(j) = low(j)+1
          WRITE (2,9003) color,field,nin,slope
        ELSEIF (j.gt.NBIN) THEN
          high(j) = high(j)+1
          WRITE (2,9003) color,field,nin,slope
        ELSE
          hist(i,j) = hist(i,j)+1
        ENDIF
      ENDIF
      GO TO 110
  120 CLOSE (1)
      CLOSE (2)
c
c...Get Normalization And Plot
c
      xbin(1) = S0
      DO i=2,NBIN
        xbin(i) = xbin(i-1)+SC
      ENDDO
      xmin = xbin(1)
      xmax = xbin(NBIN)+SC
      ymin = 0.0
      ymax = 0.0
      DO j=1,NSURVEY
        DO i=1,NBIN
          y = hist(i,j)
          ymax = MAX(ymax,y)
        ENDDO
      ENDDO
      i = ymax
      i = (i-20)/50 + 1
      ymax = i*50
      CALL mgoinit
      CALL mgosetup(-6)
      CALL mgoerase
      CALL mgosetlim(xmin,ymin,xmax,ymax)
      CALL mgobox(1,1)
      DO j=1,NSURVEY
        WRITE (*,9001) j,low(j),high(j)
        CALL mgosetltype(j)
        DO i=1,NBIN
          ybin(i) = hist(i,j)
        ENDDO
        CALL mgohistogram(xbin,ybin,NBIN)
      ENDDO
      CALL mgoprntplot(j)
      CALL EXIT
      END
