      SUBROUTINE  getusnoa
c
c...Load ACT Stars In USNO-A
c
      INCLUDE
     *            'ugapb.inc'
      PARAMETER
     *            ns = (90-15)*360000
      INTEGER
     *            i, nlb, n, nmost, nlast, nchunk, j, k, C_GENLEN,
     *            C_ROOPEN, bad, field, blue, red, fd, m
      BYTE
     *            bb(65)
      CHARACTER*64
     *            lb
c
 9001 FORMAT (q, a)
 9002 FORMAT (' Z=', i2, '  CH=', i2, '  N(CH)=', i8, '  N(PMM)=', i8)
c
c...Outer Loop Over Zones
c
  100 npmm = 0
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='../proc6/ugap7.toc',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      DO i=1,NSPDZONE
        READ (1,9001) nlb,lb
c
c...Middle Loop Over Chunks
c
        DO j=1,nlb
          bb(j) = ICHAR(lb(j:j))
        ENDDO
        bb(nlb+1) = 0
        n = C_GENLEN(bb)/12
        nchunk = ((n-1)/CHUNK) + 1
        nmost = CHUNK
        nlast = n - (nchunk-1)*nmost
        fd = C_ROOPEN(bb)
        DO j=1,nchunk
          IF (j.eq.nchunk) THEN
            n = nlast
          ELSE
            n = nmost
          ENDIF
          CALL c_reader(fd,cbuf,n*12)
c
c...Inner Loop Extracts PMM Measures Of ACT Stars
c
          DO k=1,n
            IF (cbuf(3,k).lt.0) THEN
              m = -cbuf(3,k)
              bad = m/BILLION
              m = m - bad*BILLION
              field = m/MILLION
              IF (field.gt.0) THEN
                m = m - field*MILLION
                blue = m/THOUSAND
                red = m - blue*THOUSAND
                IF ((cbuf(2,k).lt.NS).and.(field.le.606)) THEN
                  field = field+2000
                ENDIF
                npmm = npmm+1
                pmmx(npmm) = cbuf(1,k)
                pmmy(npmm) = cbuf(2,k)
                pmmf(npmm) = field
                pmmb(npmm) = blue
                pmmr(npmm) = red
                pmms(npmm) = bad
                idx(npmm) = npmm
              ENDIF
            ENDIF
          ENDDO
          WRITE (*,9002) i,j,n,npmm
        ENDDO
        CALL c_closer(fd)
      ENDDO
      CLOSE (1)
c
c...Sort On Field
c
      CALL iuqsrt(npmm,pmmf,idx)
      CALL ireord(npmm,idx,pmmx,tmp)
      CALL ireord(npmm,idx,pmmy,tmp)
      CALL ireord(npmm,idx,pmmb,tmp)
      CALL ireord(npmm,idx,pmmr,tmp)
      CALL ireord(npmm,idx,pmms,tmp)
      RETURN
      END
