      SUBROUTINE  magfit(survey,err)
c
c...Least Squares Fit To Magnitude Transformation
c
      INCLUDE
     *            'ugapb.inc'
      DOUBLE PRECISION
     *            x, z, zc, zr, chisq
      INTEGER
     *            i, j, k, nn, ising, err, jj(2), survey
c
 9001 FORMAT (' Singular Matrix In MAGFIT')
 9002 FORMAT (' MAGFIT Field=', i4, '  N(in)=', i5, '  N(out)=', i5)
 9003 FORMAT (' MAGFIT N=', i8, '  Sigma=', f5.2)
c
c...Initialization
c
  100 DO i=1,nmcoef
        zlhs(i) = 0.0D00
        DO j=1,nmcoef
          zrhs(i,j) = 0.0D00
        ENDDO
      ENDDO
      chisq = 0.0D00
      sigmam = -9.99D00
      nn = 0
c
c...Paranoia
c
      DO i=1,nmcoef
        IF (nin(i).le.5) THEN
          IF (survey.eq.1) THEN
            WRITE (*,9002) rlut12(i),nin(i),nout(i)
          ELSE
            WRITE (*,9002) rlut34(i),nin(i),nout(i)
          ENDIF
        ENDIF
      ENDDO
c
c...Accumulation
c
      DO i=1,nfit
        IF (idx(i).ne.0) THEN
          z = 0.01D00*mref(i)
          x = 0.10D00*mfit(i)
          jj(1) = 1
          dv(1) = x
          jj(2) = jfit(i)
          dv(2) = 1.0D00
          DO j=1,2
            zlhs(jj(j)) = zlhs(jj(j)) + dv(j)*z
            DO k=1,2
              zrhs(jj(j),jj(k)) = zrhs(jj(j),jj(k)) + dv(j)*dv(k)
            ENDDO
          ENDDO
          nn = nn+1
        ENDIF
      ENDDO
c
c...Inversion And Coefficients
c
      CALL matinv(nmcoef,ising)
      IF (ising.ne.0) THEN
        WRITE (*,9001)
        err = -4
        RETURN
      ENDIF
      DO i=1,nmcoef
        mcoef(i) = 0.0D00
        DO j=1,nmcoef
          mcoef(i) = mcoef(i) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Residuals And ChiSquared
c
      open (access='sequential',carriagecontrol='list',dispose='keep',
     * form='formatted',name='glop.in',status='unknown',unit=11)
      open (access='sequential',carriagecontrol='list',dispose='keep',
     * form='formatted',name='glop.out',status='unknown',unit=12)
      DO i=1,nfit
        z = 0.01D00*mref(i)
        x = 0.10D00*mfit(i)
        jj(1) = 1
        dv(1) = x
        jj(2) = jfit(i)
        dv(2) = 1.0D00
        zc = 0.0D00
        DO j=1,2
          zc = zc + mcoef(jj(j))*dv(j)
        ENDDO
        zr = z-zc
        IF (idx(i).ne.0) THEN
          chisq = chisq + zr*zr
        ENDIF
        tmp(i) = 100.0D00*zr
      if (rlut12(jj(2)).eq.363) then
      if (idx(i).eq.0) then
      write (12,9991) x,z,zc,zr,mcoef(jj(1)),mcoef(jj(2))
      else
      write (11,9991) x,z,zc,zr,mcoef(jj(1)),mcoef(jj(2))
      endif
      endif
 9991 format (6f11.5)
      ENDDO
      close (11)
      close (12)
      sigmam = SQRT(chisq/(nn-(nmcoef+1)))
c
c...Errors
c
      DO i=1,nmcoef
        smcoef(i) = sigmam*SQRT(zrhs(i,i))
      ENDDO
      err = nn
      WRITE (*,9003) nn,sigmam
      RETURN
      END
