      SUBROUTINE  pairfind
c
c...Look In Sorted Lists For Pairs
c
      INCLUDE
     *            'ugapb.inc'
      PARAMETER
     *            npmax = 100
      INTEGER
     *            get, low, high, r, xl, xh, nfind, k,
     *            ifind(NPMAX), jfind(NPMAX), test, yl,
     *            yh, yt, j, z, rfind(NPMAX)
      DOUBLE PRECISION
     *            dx, dy, dr, rsqr
c
c...Initialization
c
  100 get = 0
      npair = 0
      low = 1
      high = 1
      r = rmicron*100.0D00 + 0.5D00
      rsqr = (r/SCALE)**2
c
c...Outer Loop Over (1) Index
c
  110 get = get+1
      IF (get.gt.nhat) THEN
        close (2)
        RETURN
      ENDIF
      xl = xhat(get) - r
      xh = xhat(get) + r
      yl = yhat(get) - r
      yh = yhat(get) + r
c
c...Inner Loop Brackets (2)
c
  120 CONTINUE
      IF (actx(low).lt.xl) THEN
        IF (low.lt.nact) THEN
          low = low+1
          GO TO 120
        ENDIF
      ENDIF
      IF (actx(low).gt.xh) GO TO 110
      IF (high.lt.low) THEN
        high = low
      ENDIF
  130 CONTINUE
      IF (high.lt.nact) THEN
        IF (actx(high+1).le.xh) THEN
          high = high+1
          GO TO 130
        ENDIF
      ENDIF
c
c...Test All Unique Entries In This Range
c
      nfind = 0
      DO test=low,high
        yt = acty(test)
        IF ((yt.ge.yl).and.(yt.le.yh)) THEN
          dy = ((yt-yhat(get))/SCALE)**2
          IF (dy.le.rsqr) THEN
            dx = ((actx(test)-xhat(get))/SCALE)**2
            dr = dx+dy
            IF (dr.le.rsqr) THEN
              IF (nfind.lt.NPMAX) THEN
                nfind = nfind+1
                ifind(nfind) = get
                jfind(nfind) = test
                rfind(nfind) = SCALE*SQRT(dr)
              ENDIF
            ENDIF
          ENDIF
        ENDIF
      ENDDO
c
c...Save Pairs
c
      IF (nfind.gt.0) THEN
        npair = npair+1
        pair1(npair) = ifind(1)
        pair2(npair) = jfind(1)
        z = rfind(1)
        DO test=2,nfind
          IF (rfind(test).lt.z) THEN
            pair1(npair) = ifind(test)
            pair2(npair) = jfind(test)
            z = rfind(test)
          ENDIF
        ENDDO
      ENDIF
c
c...Loop Until Completion.  RETURN Is On GET
c
      GO TO 110
      END
