      PROGRAM  ugapc0
c
c...Compare USNO-A With Pi Program Overlays.  Formerly piprog/piprog
c
      INCLUDE
     *         'ugapc0.inc'
      PARAMETER
     *         south = -17.0D00
      INTEGER
     *         i, j, err, n, s
      CHARACTER*10
     *         cb
      CHARACTER*3
     *         suffix
c
 9001 FORMAT (' ', a, '  N(pi)=', i3, '  N(USNO-A)=', i6)
 9002 FORMAT (a, 2i5)
 9003 FORMAT (i5, 1x,a)
c
c...Initialize And Open The Parallax Program File
c
  100 CALL init
      CALL loadtoc
      CALL system('rm -f ugapc0.err')
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='piexam.out',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=2
     *     )
c
c...Loop Over Pi Program Stars
c
  110 READ (2,9002,err=110,end=130) cb,n,s
      nsname = 0
      DO i=1,LEN(cb)
        IF (cb(i:i).ne.' ') THEN
          nsname = nsname+1
          sname(nsname:nsname) = cb(i:i)
        ELSE
          GO TO 120
        ENDIF
      ENDDO
  120 CALL getpi(s)
c
c...Flag Southern Surveys
c
      IF (dcent.le.SOUTH) THEN
        suffix = '.sa'
      ELSE
        suffix = '.ua'
      ENDIF
      CALL corner
      nsav = 0
      DO j=1,ndec
        DO i=1,nra
          CALL eatit(rfrst(i),rlast(i),dzone(j),dfrst(j),dlast(j))
        ENDDO
      ENDDO
      WRITE (*,9001) sname(1:nsname),npi,nsav
      CALL iterate(0,err)
      IF (err.eq.0) THEN
        CALL saveit(suffix)
      ELSE
        OPEN (
     *        access='append',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name='ugapc0.err',
     *        status='unknown',
     *        unit=1
     *       )
        WRITE (1,9003) err,sname(1:nsname)
        CLOSE (1)
      ENDIF
      GO TO 110
c
c...All Done
c
  130 CLOSE (2)
      CALL system('cat ugapc0.err')
      CALL EXIT
      END
