      PROGRAM  ugapc1
c
c...Get UA Files Into Something Better For Fitting Colors
c
c	Formerly piprog/color0
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nsavmin = 6,
     *         nsavmax = 100
      INTEGER
     *         n, nsname, nin, nout, ncoef, nstar, nsave, i, plate, p,
     *         pfind(2000), npfind, j, i1(NSAVMAX), i2(NSAVMAX),
     *         i3(NSAVMAX), i4(NSAVMAX), nua, nrej
      REAL
     *         vv, ii, bb, mo, me, r1(NSAVMAX), r2(NSAVMAX),
     *         r3(NSAVMAX), r4(NSAVMAX), r5(NSAVMAX)
      CHARACTER*64
     *         sname, in, out
      CHARACTER*2
     *         suffix
c
 9001 FORMAT (q, a)
 9002 FORMAT (2i10)
 9003 FORMAT (i3, 24x, 3f6.0, 17x, 2f6.0, 24x, i5)
 9004 FORMAT (2i5, 5f6.2, 2i5)
 9005 FORMAT (' Processing Star ', a)
 9006 FORMAT (' Too Few...N=', i3)
 9007 FORMAT (' N(star)=', i3, '   N(plate)=', i3, '  N(UA)=', i3,
     *        '  N(rej)=', i3)
 9008 FORMAT (i5, 1x,a)
c
c...Get And Open List
c
  100 CALL system('\ls $PIPROG >ugapc1.inp')
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='ugapc1.inp',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      n = 0
      npfind = 0
      nua = 0
      nrej = 0
      CALL system('rm -f ugapc1.err')
c
c...Open Master Output File
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='ugapc1.out',
     *      status='unknown',
     *      unit=2
     *     )
c
c...Loop Over Each UA File
c
  110 READ (1,9001,err=110,end=120) nsname,sname
      IF (nsname.le.4) GO TO 110
      IF (sname(nsname-2:nsname).eq.'.ua')THEN
        suffix = 'ph'
      ELSEIF (sname(nsname-2:nsname).eq.'.sa') THEN
        suffix = 'sh'
      ELSE
        GO TO 110
      ENDIF
      nua = nua+1
      CALL f_doenv('PIPROG:'//sname(1:nsname),nin,in)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=in(1:nin),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=3
     *     )
      nsname = nsname-3
      WRITE (*,9005) sname(1:nsname)
      nsave = 0
c
c...Process This Star
c
      READ (3,9002) ncoef,nstar
      DO i=1,ncoef
        READ (3,9002)
      ENDDO
      DO i=1,nstar
        READ (3,9003) j,bb,vv,ii,mo,me,plate
        IF  ((mo.gt.0.0).and.(me.gt.0.0)
     *  .and.(vv.gt.0.0).and.(ii.gt.0.0)) THEN
          IF (nsave.eq.0) THEN
            DO p=1,npfind
              IF (plate.eq.pfind(p)) GO TO 115
            ENDDO
            npfind = npfind+1
            pfind(npfind) = plate
            p = npfind
  115       CONTINUE
          ENDIF
          nsave = nsave+1
          i2(nsave) = p
          i3(nsave) = i
          i4(nsave) = pfind(p)
          r1(nsave) = mo
          r2(nsave) = me
          r3(nsave) = bb
          r4(nsave) = vv
          r5(nsave) = ii
        ENDIF
      ENDDO
c
c...Save This Star If Enough Entries
c
      IF (nsave.ge.NSAVMIN) THEN
        n = n+1
        out = in
        nout = nin
        out(nout-1:nout) = suffix
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name=out(1:nout),
     *        status='unknown',
     *        unit=4
     *       )
        DO i=1,nsave
          WRITE (2,9004) n,i2(i),r1(i),r2(i),r3(i),r4(i),r5(i),
     *                   i3(i),i4(i)
          WRITE (4,9004) n,i2(i),r1(i),r2(i),r3(i),r4(i),r5(i),
     *                   i3(i),i4(i)
        ENDDO
        CLOSE (4)
      ELSE
        WRITE (*,9006) nsave
        nrej = nrej+1
        OPEN (
     *        access='append',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name='ugapc1.err',
     *        status='unknown',
     *        unit=4
     *       )
        WRITE (4,9008) nsave,sname(1:nsname)
        CLOSE (4)
      ENDIF
c
c...Done With This Star
c
      CLOSE (3)
      GO TO 110
c
c...Done With All Stars
c
  120 CLOSE (1)
      CLOSE (2)
      WRITE (*,9007) n,npfind,nua,nrej
      CALL system('cat ugapc1.err')
      CALL EXIT
      END
