      SUBROUTINE  eachfit(nn,ff,xx,yy,coef,scoef,sigma,in,res)
c
c...Perform The Fit
c
      INCLUDE
     *            'ugapcs0.inc'
      INTEGER
     *            nn, ff(*), xx(*), yy(*), in(*), res(*), i, j, k,
     *            ising, jj(3), nin
      DOUBLE PRECISION
     *            coef(*), scoef(*), sigma, chisq, x, y, yc, yr
c
 9001 FORMAT (' Singular Matrix In EACHFIT')
c
c...Initialization
c
  100 ncoef = nplate+1
      DO i=1,ncoef
        zlhs(i) = 0.0D00
        DO j=1,ncoef
          zrhs(i,j) = 0.0D00
        ENDDO
        coef(i) = 0.0D00
        scoef(i) = -1.0D00
      ENDDO
      chisq = 0.0D00
      nin = 0
c
c...Accumulate
c
      DO i=1,nn
        IF (in(i).ne.0) THEN
          x = 0.1D00*xx(i)
          y = 0.01D00*yy(i)
          jj(1) = flut(ff(i))
          dv(1) = 1.0D00
          jj(2) = ncoef
          dv(2) = x
          DO j=1,2
            zlhs(jj(j)) = zlhs(jj(j)) + dv(j)*y
            DO k=1,2
              zrhs(jj(j),jj(k)) = zrhs(jj(j),jj(k)) + dv(j)*dv(k)
            ENDDO
          ENDDO
          nin = nin+1
        ENDIF
      ENDDO
c
c...Invert
c
      CALL matinv(ising)
      IF (ising.ne.0) THEN
        WRITE (*,9001)
        CALL EXIT
      ENDIF
c
c...Coefficients
c
      DO i=1,ncoef
        DO j=1,ncoef
          coef(i) = coef(i) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Residuals And ChiSqaured
c
      DO i=1,nn
        x = 0.1D00*xx(i)
        y = 0.01D00*yy(i)
        jj(1) = flut(ff(i))
        dv(1) = 1.0D00
        jj(2) = ncoef
        dv(2) = x
        yc = 0.0D00
        DO j=1,2
          yc = yc + coef(jj(j))*dv(j)
        ENDDO
        yr = y-yc
        res(i) = 100.0D00*yr
        IF (in(i).ne.0) THEN
          chisq = chisq + yr*yr
        ENDIF
      ENDDO
c
c...Errors
c
      sigma = SQRT(chisq/(nin-(ncoef+1)))
      DO i=1,ncoef
        scoef(i) = sigma*SQRT(zrhs(i,i))
      ENDDO
      RETURN
      END
