      SUBROUTINE  fitloop
c
c...Fit For Offset Plus Slope
c
      INCLUDE
     *            'ugapcs0.inc'
      PARAMETER
     *            too_bright = 1300
      INTEGER
     *            i, pl, j
      DOUBLE PRECISION
     *            pmmj, pmmf, ccdj, ccdf, jr, fr
c
 9001 FORMAT (' Too Many Coefficients', i11)
 9002 FORMAT (' N(plate)=', i3)
 9003 FORMAT (i5, 2f10.2)
 9004 FORMAT (i5, 4(1x,1pe15.8))
 9005 FORMAT (i5, 2(i2, 3f6.2))
 9006 FORMAT (' FITLOOP  Signa(j)=', f5.2, '  Sigma(f)=', f5.2)
c
c...Sort On Plate ID And Count Number Of Plates
c
  100 DO i=1,nsave
        idx(i) = i
      ENDDO
      CALL iuqsrt(nsave,save(1,1),idx)
      CALL ireord(nsave,idx,save(1,2),tmp)
      CALL ireord(nsave,idx,save(1,3),tmp)
      CALL ireord(nsave,idx,save(1,4),tmp)
      CALL ireord(nsave,idx,save(1,5),tmp)
      DO i=1,NFMAX
        flut(i) = 0
        rlut(i) = 0
      ENDDO
      nplate = 1
      flut(save(1,1)) = nplate
      rlut(nplate) = save(1,1)
      DO i=2,nsave
        IF (save(i,1).ne.save(i-1,1)) THEN
          nplate = nplate+1
          flut(save(i,1)) = nplate
          rlut(nplate) = save(i,1)
        ENDIF
      ENDDO
      IF (ncoef.gt.NCMAX) THEN
        WRITE (*,9001) ncoef
        CALL EXIT
      ENDIF
      WRITE (*,9002) nplate
c
c...Fit J
c
      DO i=1,nsave
        IF (save(i,4).lt.TOO_BRIGHT) THEN
          inj(i) = 0
        ELSE
          inj(i) = 1
        ENDIF
      ENDDO
      CALL eachfit(nsave,save(1,1),save(1,2),save(1,4),jcoef,sjcoef,
     *             sigmaj,inj,jres)
      CALL trimit(nsave,sigmaj,jres,inj)
      CALL eachfit(nsave,save(1,1),save(1,2),save(1,4),jcoef,sjcoef,
     *             sigmaj,inj,jres)
      CALL trimit(nsave,sigmaj,jres,inj)
      CALL eachfit(nsave,save(1,1),save(1,2),save(1,4),jcoef,sjcoef,
     *             sigmaj,inj,jres)
c
c...Fit F
c
      DO i=1,nsave
        inf(i) = inj(i)
      ENDDO
      CALL eachfit(nsave,save(1,1),save(1,3),save(1,5),fcoef,sfcoef,
     *             sigmaf,inf,fres)
      CALL trimit(nsave,sigmaf,fres,inf)
      CALL eachfit(nsave,save(1,1),save(1,3),save(1,5),fcoef,sfcoef,
     *             sigmaf,inf,fres)
      CALL trimit(nsave,sigmaf,fres,inf)
      CALL eachfit(nsave,save(1,1),save(1,3),save(1,5),fcoef,sfcoef,
     *             sigmaf,inf,fres)
c
c...Save The Fit
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='ugapcs0.xfit',
     *      status='unknown',
     *      unit=1
     *     )
      WRITE (1,9003) ncoef,sigmaj,sigmaf
      DO i=1,ncoef
        IF (i.le.nplate) THEN
          WRITE (1,9004) rlut(i),jcoef(i),fcoef(i),sjcoef(i),sfcoef(i)
        ELSE
          j = nplate-i
          WRITE (1,9004) j,jcoef(i),fcoef(i),sjcoef(i),sfcoef(i)
        ENDIF
      ENDDO
      CLOSE (1)
c
c...Save Residuals
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='ugapcs0.xres',
     *      status='unknown',
     *      unit=1
     *     )
      DO i=1,nsave
        pl = save(i,1)
        pmmj = 0.1D00*save(i,2)
        pmmf = 0.1D00*save(i,3)
        ccdj = 0.01D00*save(i,4)
        ccdf = 0.01D00*save(i,5)
        jr   = 0.01D00*jres(i)
        fr   = 0.01D00*fres(i)
        WRITE (1,9005) pl,inj(i),pmmj,ccdj,jr,inf(i),pmmf,ccdf,fr
      ENDDO
      CLOSE (1)
      WRITE (*,9006) sigmaj,sigmaf
      RETURN
      END
