      SUBROUTINE  looper
c
c...Search Each Zone Of USNO-A
c
      INCLUDE
     *            'ugapcs0.inc'
      PARAMETER
     *            zscale = 75*360*100,
     *            billion = 1000*1000*1000,
     *            million = 1000*1000,
     *            thousand = 1000
      INTEGER
     *            zmin, zmax, z, i, j, dr, dd, smin, smax, k, m, mb,
     *            mr, ff, miss, nopmm, sat
      DOUBLE PRECISION
     *            d, cd, ccdj, ccdf, pmmj, pmmf
c
 9001 FORMAT (i4, 4f6.2, 4i11, 2i4)
 9002 FORMAT (' N(save)=', i5)
c
c...Get Zones
c
  100 z = spmspd(1)/ZSCALE
      zmin = z
      zmax = z
      DO i=2,nspm
        z = spmspd(i)/ZSCALE
        zmin = MIN(z,zmin)
        zmax = MAX(z,zmax)
      ENDDO
      nsave = 0
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='ugapcs0.out',
     *      status='unknown',
     *      unit=2
     *     )
      DO j=zmin,zmax
        z = j*75
c
c...Extract Objects In This Stripe
c
        smin = z*36000
        smax = smin + 75*36000
        nper = 0
        DO i=1,nspm
          IF ((spmspd(i).ge.smin).and.(spmspd(i).lt.smax)) THEN
            nper = nper+1
            rper(nper) = spmra(i)
            sper(nper) = spmspd(i)
            fper(nper) = spmmf(i)
            jper(nper) = spmmj(i)
            iper(nper) = spmid(i)
          ENDIF
        ENDDO
c
c...Process Each Object
c
        DO i=1,nper
          d = (sper(i)/360000.0D00) - 90.0D00
          dd = 100.0D00*rarcsec
          dr = dd/COSD(d)
          CALL loadit(j,rper(i)-dr,rper(i)+dr)
          CALL findit(rper(i),sper(i),dr,dd,k)
          IF (k.gt.0) THEN
            m = ABS(buf(3,k))
            sat = m/BILLION
            m = m - sat*BILLION
            ff = m/MILLION
            IF ((sat.eq.0).and.(ff.gt.0)) THEN
              m = m - ff*MILLION
              mb = m/THOUSAND
              mr = m - mb*THOUSAND
              IF  ((mb.gt.0).and.(mb.lt.200)
     *        .and.(mr.gt.0).and.(mr.lt.200)) THEN
                pmmj = 0.1D00*mb
                pmmf = 0.1D00*mr
                ccdj = 0.01D00*jper(i)
                ccdf = 0.01D00*fper(i)
                WRITE (2,9001) ff,ccdj,ccdf,pmmj,pmmf,iper(i),buf(1,k),
     *                         buf(2,k),buf(3,k),buf(1,k)-rper(i),
     *                         buf(2,k)-sper(i)
                nsave = nsave+1
                save(nsave,1) = ff
                save(nsave,2) = mb
                save(nsave,3) = mr
                save(nsave,4) = jper(i)
                save(nsave,5) = fper(i)
              ENDIF
            ENDIF
          ENDIF
        ENDDO
c
c...All Done
c
      ENDDO
      CLOSE (2)
      WRITE (*,9002) nsave
      RETURN
      END
