      SUBROUTINE  limits
c
c...Compute Limits For Extraction
c
      INCLUDE
     *            'gen.inc'
      DOUBLE PRECISION
     *            xi, eta, r(8), d(8), rmn, rmx, dmn, dmx, rl(2), rh(2)
      INTEGER
     *            xm(8), ym(8), i
      DATA
     *      xm/-1,-1, 1, 1, 0, 1, 0,-1/,
     *      ym/-1, 1,-1, 1, 1, 0,-1, 0/
c
 9001 FORMAT (' Search Limits ', 4i11)
c
c...Compute RA,Dec For Corners And Centers
c
  100 DO i=1,8
        xi  = xm(i)*field_wide/obs_unit
        eta = ym(i)*field_wide/obs_unit
        CALL sla_DTP2S(xi,eta,field_ora,field_odec,r(i),d(i))
        IF (i.eq.1) THEN
          rmn = r(i)
          rmx = rmn
          dmn = d(i)
          dmx = dmin
        ELSE
          rmn = MIN(rmn,r(i))
          rmx = MAX(rmx,r(i))
          dmn = MIN(dmn,d(i))
          dmx = MAX(dmx,d(i))
        ENDIF
      ENDDO
c
c...Figure Out If We Need 1 Or 2 Chunks Of RA
c
      IF ((rmx-rmn).le.pi) THEN
        nra = 1
        rl(1) = rmn
        rh(1) = rmx
      ELSE
        nra = 2
        rl(1) = 0.0D00
        rh(1) = rl(1)
        rh(2) = twopi
        rl(2) = rh(2)
        DO i=1,8
          IF (r(i).le.pi) THEN
            rh(1) = MAX(rh(1),r(i))
          ELSE
            rl(2) = MIN(rl(2),r(i))
          ENDIF
        ENDDO
      ENDIF
      DO i=1,nra
        rmin(i) = rl(i)*radian*360000.0D00
        rmax(i) = rh(i)*radian*360000.0D00
      ENDDO
      dmin = ((dmn*radian)+90.0D00)*360000.0D00
      dmax = ((dmx*radian)+90.0D00)*360000.0D00
      DO i=1,nra
        WRITE (*,9001) rmin(i),rmax(i),dmin,dmax
      ENDDO
      RETURN
      END
