      SUBROUTINE  observatory
c
c...Set Observatory Defaults
c
      INCLUDE
     *            'gen.inc'
      CHARACTER*64
     *            lb
      CHARACTER*1
     *            c
      INTEGER
     *            i, nlb
c
 9001 FORMAT (' Observatory (NULL=Manual): ' $)
 9002 FORMAT (q, a)
 9003 FORMAT ('East Longitude: ' $)
 9004 FORMAT ('      Latitude: ' $)
 9005 FORMAT ('  Elevation(m): ' $)
 9006 FORMAT (' Scale(sec/mm): ' $)
 9007 FORMAT (f10.0)
c
  100 WRITE (*,9001)
      READ  (*,9002,err=100) nlb,lb
      IF (nlb.le.0) GO TO 110
      DO i=1,nlb
        c = lb(i:i)
        IF ((c.ge.'A').and.(c.le.'Z')) THEN
          c = CHAR(ICHAR(c)+32)
        ENDIF
        lb(i:i) = c
      ENDDO
      IF (INDEX(lb(1:nlb),'pal').gt.0) THEN
        obs_long = -(116.0D00 + 51.8D00/60.0D00)/radian
        obs_lat = (33.0D00 + 21.4D00/60.0D00)/radian
        obs_elev = 1706.0D00
        obs_scale = 67.18D00
        obs_disco = -0.3333D00
        field_xmid = 17000000
        field_ymid = 17500000
        field_wide = 17780000
        field_flip = 1
        RETURN
      ELSEIF (INDEX(lb(1:nlb),'aao').gt.0) THEN
        obs_long = (149.07)/radian
        obs_lat = (-31.27)/radian
        obs_elev = 1130.0D00
        obs_scale = 67.18D00
        obs_disco = -0.3333D00
        field_xmid = 17000000
        field_ymid = 17500000
        field_wide = 17780000
        field_flip = 1
        RETURN
      ELSEIF (INDEX(lb(1:nlb),'eso').gt.0) THEN
        obs_long = -(70.0D00 + 43.8D00/60.0D00)/radian
        obs_lat = -(29.0D00 + 15.4D00/60.0D00)/radian
        obs_elev = 2347.0D00
        obs_scale = 67.18D00
        obs_disco = -0.3333D00
        field_xmid = 15200000
        field_ymid = 15200000
        field_wide = 16000000
        field_flip = 0
        RETURN
      ELSEIF (INDEX(lb(1:nlb),'lick').gt.0) THEN
        obs_long = -(121.0D00 + 38.2D00/60.0D00)/radian
        obs_lat = (37.0D00 + 20.6D00/60.0D00)/radian
        obs_elev = 1290.0D00
        obs_scale = 55.10D00
        obs_disco = 0.0D00
        field_xmid = 21000000
        field_ymid = 21000000
        field_wide = 21590000
        field_flip = 0
        RETURN
      ELSEIF (INDEX(lb(1:nlb),'usno').gt.0) THEN
        obs_long = -(77.0D00 + 04.0D00/60.0D00)/radian
        obs_lat = (38.0D00 + 55.3D00/60.0D00)/radian
        obs_elev = 92.0D00
        obs_scale = 100.50D00
        field_xmid = 11500000
        field_ymid = 9000000
        field_wide = 9000000
        field_flip = 0
        RETURN
      ENDIF
c
c...Manual Entry
c
  110 WRITE (*,9003)
      READ  (*,9002) nlb,lb
      IF (nlb.le.0) GO TO 110
      CALL hms(lb(1:nlb),obs_long)
      obs_long = obs_long/radian
  120 WRITE (*,9004)
      READ  (*,9002) nlb,lb
      IF (nlb.le.0) GO TO 120
      CALL hms(lb(1:nlb),obs_lat)
      obs_lat = obs_lat/radian
  130 WRITE (*,9005)
      READ  (*,9007) obs_elev
  140 WRITE (*,9006)
      READ  (*,9007) obs_scale
      field_xmid = 0
      field_ymid = 0
      field_wide = 0
      field_flip = 0
      obs_disco = 0.0D00
      RETURN
      END
