      SUBROUTINE  aprelim
c
c...Recover UJ Catalog Piece(s) That Covers B List
c
      INCLUDE
     *         'genover.inc'
      INTEGER
     *         nq, qrmin(4), qrmax(4),
     *         qdmin(4), qdmax(4), i, eps, s, nlb, loop
      CHARACTER*6
     *         tb
      DOUBLE PRECISION
     *         d, x1, x2, y1, y2
c
 9002 FORMAT (' Looking For SJ', i4.4)
 9003 FORMAT ('sj', i4.4)
 9004 FORMAT (' Search RA(', f6.3, ',', f6.3, ')  Dec(', f7.3, ',',
     *        f7.3, ')')
c
c...Look At J
c
  100 IF (nbj.le.0) THEN
        djmin = TAG
        djmax = TAG
        rjmin = TAG
        rjmax = TAG
      ELSE
        djmin = bjdec(1)
        djmax = djmin
        rjmin = bjra(1)
        rjmax = rjmin
        DO i=2,nbj
          djmin = MIN(djmin,bjdec(i))
          djmax = MAX(djmax,bjdec(i))
          rjmin = MIN(rjmin,bjra(i))
          rjmax = MAX(rjmax,bjra(i))
        ENDDO
      ENDIF
      dmin = djmin
      dmax = djmax
      rmin = rjmin
      rmax = rjmax
c
c...Look At H
c
      IF (nbh.le.0) THEN
        dhmin = TAG
        dhmax = TAG
        rhmin = TAG
        rhmax = TAG
      ELSE
        dhmin = bhdec(1)
        dhmax = dhmin
        rhmin = bhra(1)
        rhmax = rhmin
        DO i=2,nbh
          dhmin = MIN(dhmin,bhdec(i))
          dhmax = MAX(dhmax,bhdec(i))
          rhmin = MIN(rhmin,bhra(i))
          rhmax = MAX(rhmax,bhra(i))
        ENDDO
        IF (dmin.eq.TAG) THEN
          dmin = dhmin
        ELSE
          dmin = MIN(dmin,dhmin)
        ENDIF
        IF (dmax.eq.TAG) THEN
          dmax = dhmax
        ELSE
          dmax = MAX(dmax,dhmax)
        ENDIF
        IF (rmin.eq.TAG) THEN
          rmin = rhmin
        ELSE
          rmin = MIN(rmin,rhmin)
        ENDIF
        IF (rmax.eq.TAG) THEN
          rmax = rhmax
        ELSE
          rmax = MAX(rmax,rhmax)
        ENDIF
      ENDIF
c
c...Look At K
c
      IF (nbk.le.0) THEN
        dkmin = TAG
        dkmax = TAG
        rkmin = TAG
        rkmax = TAG
      ELSE
        dkmin = bkdec(1)
        dkmax = dkmin
        rkmin = bkra(1)
        rkmax = rkmin
        DO i=1,nbk
          dkmin = MIN(dkmin,bkdec(i))
          dkmax = MAX(dkmax,bkdec(i))
          rkmin = MIN(rkmin,bkra(i))
          rkmax = MAX(rkmax,bkra(i))
        ENDDO
        IF (dmin.eq.TAG) THEN
          dmin = dkmin
        ELSE
          dmin = MIN(dmin,dkmin)
        ENDIF
        IF (dmax.eq.TAG) THEN
          dmax = dkmax
        ELSE
          dmax = MAX(dmax,dkmax)
        ENDIF
        IF (rmin.eq.TAG) THEN
          rmin = rkmin
        ELSE
          rmin = MIN(rmin,rkmin)
        ENDIF
        IF (rmax.eq.TAG) THEN
          rmax = rkmax
        ELSE
          rmax = MAX(rmax,rkmax)
        ENDIF
      ENDIF
c
c...Pad To Allow For Error Radius
c
      d = MAX(ABS(dmin-DOFFSET),ABS(dmax-DOFFSET))/DDFACTOR
      eps = 100.0D00*radius/COSD(d)
      IF ((rmax-rmin).lt.HALF_CIRCLE) THEN
        field_mra = ((rmax+rmin+1)/2)/DRFACTOR
        field_mdec = (((dmax+dmin+1)/2)-DDOFFSET)/DDFACTOR
        rmin = rmin-eps
        IF (rmin.lt.0) THEN
          rmin = rmin+CIRCLE
        ENDIF
        rmax = rmax+eps
        IF (rmax.ge.CIRCLE) THEN
          rmax = rmax-CIRCLE
        ENDIF
      ELSE
        field_mra = ((rmax+rmin+1-CIRCLE)/2)/DRFACTOR
        IF (field_mra.lt.0.0D00) THEN
          field_mra = field_mra + 24.0D00
        ENDIF
        field_mdec = (((dmax+dmin+1)/2)-DDOFFSET)/DDFACTOR
        rmin = rmin+eps
        rmax = rmax-eps
      ENDIF
      dmin = dmin-eps
      dmax = dmax+eps
c
c...Tell The User
c
      x1 = rmin/DRFACTOR
      x2 = rmax/DRFACTOR
      y1 = (dmin-DDOFFSET)/DDFACTOR
      y2 = (dmax-DDOFFSET)/DDFACTOR
      WRITE (*,9004) x1,x2,y1,y2
      CALL sub4c(x1,x2,y1,y2,nfp1,fp1,nfp2,fp2)
      RETURN
      END
