      SUBROUTINE  apsproject
c
c...Project Catalog To Tangent Plane.

c
      INCLUDE
     *            'genover.inc'
      INTEGER
     *             i, j
      DOUBLE PRECISION
     *             r_hour, d_degree, r_radian, d_radian, cra, cdec,
     *             xi, eta
c
 9001 FORMAT (' DS2TP Error ', i3, 4f12.6)
c
c...Compute Center
c
  100 field_mra = field_mra*ra_to_rad
      field_mdec = field_mdec*dec_to_rad
c
      DO i=1,naps
        r_hour = apsra(i)/DRFACTOR
        d_degree = (apsdec(i)-DDOFFSET)/DDFACTOR
        r_radian = r_hour*ra_to_rad
        d_radian = d_degree*dec_to_rad
        CALL sla_DS2TP(r_radian,d_radian,field_mra,field_mdec,
     *                 xi,eta,j)
        IF (j.ne.0) THEN
          WRITE (*,9001) j,r_radian,d_radian,field_mra,field_mdec
          CALL exit
        ENDIF
        ara(i) = xi*obs_unit
        adec(i) = eta*obs_unit
        IF (survey.eq.'sj') THEN
          amag(i) = apsomag(i)
        ELSE
          amag(i) = apsemag(i)
        ENDIF
        aid(i) = apsid(i)
        aira(i) = apsra(i)
        aidec(i) = apsdec(i)
        idx(i) = i
      ENDDO
      na = naps
      CALL iuqsrt(na,ara,idx)
      CALL ireord(na,idx,aid,tmp)
      CALL ireord(na,idx,adec,tmp)
      CALL ireord(na,idx,amag,tmp)
      CALL ireord(na,idx,aira,tmp)
      CALL ireord(na,idx,aidec,tmp)
c
      field_mra = field_mra/ra_to_rad
      field_mdec = field_mdec/dec_to_rad
      RETURN
      END
