      SUBROUTINE  crack(fn)
c
c...Crack IPAC Format Data Files
c
      INCLUDE
     *            'astrom0.inc'
      CHARACTER*(*)
     *            fn
      CHARACTER*132
     *            lb
      CHARACTER*1
     *            b
      INTEGER
     *            nlb, nmerg, nfr, fno, rno, nrel, i
      REAL
     *            xf, yf, xs, ys, m
c
 9001 FORMAT (i7, i4, i3, 1x,a, i6, 2f9.2, 3f7.2)
 9002 FORMAT (q, a)
 9003 FORMAT (' Cannot Open ', a)
c
c...Open File And Initialize
c
  100 CALL f_doenv(fn,nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      nn = 0
c
c...Ingest
c
  110 READ (1,9002,end=120) nlb,lb
      IF (lb(1:1).eq.'|') GO TO 110
      READ (lb(1:nlb),9001) nmerg,nfr,rno,b,nrel,xf,yf,xs,ys,m
      nn = nn+1
      ident(nn) = nmerg
      frame(nn) = nfr
      r12(nn)   = rno
      xpos(nn)  = xf
      ypos(nn)  = yf
      xsig(nn)  = xs
      ysig(nn)  = ys
      mag(nn)   = m
      IF (b.eq.'J') THEN
        band(nn) = 1
      ELSEIF (b.eq.'H') THEN
        band(nn) = 2
      ELSEIF (b.eq.'K') THEN
        band(nn) = 3
      ELSE
      write (*,9991) lb(1:nlb)
      pause
 9991 format (' Parse Error ', a)
      ENDIF
      GO TO 110
  120 CLOSE (1)
      write (*,9992) nn
 9992 format (7i11)
c
c...Sort On Star Number And On Frame Number
c
      DO i=1,nn
        tmp(i) = ident(i)
        sidx(i) = i
      ENDDO
      CALL iuqsrt(nn,tmp,sidx)
      CALL stack(nn,tmp, ns,sval,sfrst,slast)
      write (*,9992) ns
      DO i=1,nn
        tmp(i) = frame(i)
        fidx(i) = i
      ENDDO
      CALL iuqsrt(nn,tmp,fidx)
      CALL stack(nn,tmp, nf,fval,ffrst,flast)
      write (*,9992) nf
c
c...All Done
c
      RETURN
  200 WRITE (*,9003) lb(1:nlb)
      CALL EXIT
      END
