      SUBROUTINE  ffit1
c
c...Fit Frames
c
c	All Detections, No Weighting
c
      INCLUDE
     *            'astrom0.inc'
      PARAMETER
     *            dx = 0.17D00,
     *            dy = -41.74D00
      INTEGER
     *            curr, prev, cf, cl, pf, pl, sn, i, j
      DOUBLE PRECISION
     *            sx, sxx, sy, syy, x, y, tx, ty
c
c...Loop Over Current Frame+Previous Frame Pair
c
  100 tx = 0.0D00
      ty = 0.0D00
      DO curr=2,nf
        cf = ffrst(curr)
        cl = flast(curr)
        prev = curr-1
        pf = ffrst(prev)
        pl = flast(prev)
c
c...Look For Paired Stars
c
        sn = 0
        sx = 0.0D00
        sy = 0.0D00
        sxx = 0.0D00
        syy = 0.0D00
        DO i=cf,cl
          DO j=pf,pl
            IF (ident(fidx(i)).eq.ident(fidx(j))) THEN
              sn = sn+1
              x = xpos(fidx(i))-xpos(fidx(j))
              sx = sx+x
              sxx = sxx+x*x
              y = ypos(fidx(i))-ypos(fidx(j))
              sy = sy+y
              syy = syy+y*y
              GO TO 110
            ENDIF
          ENDDO
  110     CONTINUE
        ENDDO
c
c...Solve If We Can
c
        IF (sn.le.0) THEN
          CONTINUE
        ELSE
          sx = sx/sn
          sy = sy/sn
          IF (sn.eq.1) THEN
            sxx = 0.0D00
            syy = 0.0D00
          ELSE
            sxx = SQRT(sxx/sn - sx*sx)
            syy = SQRT(syy/sn - sy*sy)
          ENDIF
        ENDIF
        nfit(curr) = sn
        xfit(curr) = sx
        yfit(curr) = sy
        sxfit(curr) = sxx
        syfit(curr) = syy
      ENDDO
      open (access='sequential',carriagecontrol='list',dispose='keep',
     * form='formatted',name='glop',status='unknown',unit=1)
      do i=2,nf
      tx = tx + (xfit(i)-DX)
      ty = ty + (yfit(i)-DY)
      write (1,9991) i,nfit(i),xfit(i),sxfit(i),yfit(i),syfit(i),
     * tx,ty
      enddo
      close (1)
 9991 format (2i6, 6f10.3)
      RETURN
      END
