      SUBROUTINE  resproc(who)
c
c...Attempt To Process .ES Sources
c
      INCLUDE
     *            'reload.inc'
      PARAMETER
     *            es_scale = 1000.0D00,
     *            em_scale = 100.0D00
      INTEGER
     *            i, nlb, id, who
      DOUBLE PRECISION
     *            x, y, m, xhat, yhat, ex, ey
      CHARACTER*132
     *            lb
c
 9001 FORMAT (' Cannot Open ', a)
 9002 FORMAT (i6, 3f9.0)
 9003 FORMAT (q, a)
 9004 FORMAT (a)
 9005 FORMAT (i6, 3i12, 2f10.2, f10.3)
 9006 FORMAT (' BPS Fit EX=', f6.2, '  EY=', f6.2, ' (microns)')
c
c...Nothing To Do If We Can't Find The File.  Open It First
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=broot(1:nbroot)//'.es',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=210,
     *      form='formatted',
     *      name=broot(1:nbroot)//'.ps',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=2
     *     )
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=broot(1:nbroot)//'.es_s',
     *      status='unknown',
     *      unit=3
     *     )
c
c...Start By Generating LookUp Table For .p.ps_s Sources
c
      DO i=1,NMAX
        tmp(i) = 0
      ENDDO
      DO i=1,nb
        IF (bid(i).lt.200000) THEN
          tmp(bid(i)) = i
        ELSEIF (bid(i).lt.400000) THEN
          tmp(bid(i)-200000) = i
        ENDIF
      ENDDO
      DO i=1,3
        READ (2,9002)
      ENDDO
      nps = 0
  110 READ (2,9002,end=120) id,x,y,m
      IF (tmp(id).gt.0) THEN
        nps = nps+1
        idx(nps) = tmp(id)
        xps(nps) = x*ES_SCALE
        yps(nps) = y*ES_SCALE
      ENDIF
      GO TO 110
  120 CLOSE (2)
c
c...Fit And Then Project .ES Entries
c
      ncoef = 10
      CALL psfit( bra,bxcoef,sbxcoef,ex)
      CALL psfit(bdec,bycoef,sbycoef,ey)
      ex = 0.01D00*ex
      ey = 0.01D00*ey
      WRITE (*,9006) ex,ey
      DO i=1,3
        READ (1,9003) nlb,lb
        IF (nlb.le.0) THEN
          WRITE (3,9004)
        ELSE
          WRITE (3,9004) lb(1:nlb)
        ENDIF
      ENDDO
  130 READ (1,9002,end=140) id,x,y,m
      x = x*ES_SCALE
      y = y*ES_SCALE
      CALL filldv(x,y)
      xhat = 0.0D00
      yhat = 0.0D00
      DO i=1,ncoef
        xhat = xhat + dv(i)*bxcoef(i)
        yhat = yhat + dv(i)*bycoef(i)
      ENDDO
      nb = nb+1
      bid(nb) = id+500000
      bra(nb) = xhat
      bdec(nb) = yhat
      bmag(nb) = EM_SCALE*m
      WRITE (3,9005) bid(nb),bra(nb),bdec(nb),bmag(nb),x,y,m
      GO TO 130
  140 CLOSE (1)
      CLOSE (3)
      RETURN
c
c...Exit For Missing Files
c
  200 WRITE (*,9001) lb(1:nlb)
      RETURN
  210 WRITE (*,9001) lb(1:nlb)
      CLOSE (1)
      RETURN
      END
