      SUBROUTINE  jfoeread
c
c...Read The JFOE Files
c
      INCLUDE
     *            'lookup.inc'
      INTEGER
     *            nlb, ntb, i, j, k
      CHARACTER*64
     *            lb, tb
c
 9001 FORMAT ('AUXJFOE:jf', i4.4, 'oe', i4.4, '.fit')
 9002 FORMAT (' Cannot Open ', a)
 9003 FORMAT (i2, 2i10)
 9004 FORMAT (2x, 2(1x,1pe15.8))
 9005 FORMAT (i10)
c
  100 WRITE (lb,9001) jfid,oeid
      nlb = 24
      CALL f_doenv(lb(1:nlb),ntb,tb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=tb(1:ntb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      DO k=1,4
        READ (1,9003) j,nxform(j),npover
        DO i=1,nxform(j)
          READ (1,9004) xform(i,j),yform(i,j)
        ENDDO
      ENDDO
      CLOSE (1)
c
c...Read The Pairs File
c
      tb(ntb-2:ntb) = 'par'
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=200,
     *      form='unformatted',
     *      name=tb(1:ntb),
     *      readonly,
     *      recl=npover,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      DO j=1,4
        READ (1,rec=j) (pover(i,j),i=1,npover)
      ENDDO
      CLOSE (1)
c
c...Read The Unpaired JF Pairs
c
      tb(ntb-2:ntb) = 'fjf'
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=tb(1:ntb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9003) i,j,njf
      CLOSE (1)
      tb(ntb-2:ntb) = 'pjf'
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=200,
     *      form='unformatted',
     *      name=tb(1:ntb),
     *      readonly,
     *      recl=njf,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1) (pjf(i,1),i=1,njf)
      READ (1,rec=2) (pjf(i,2),i=1,njf)
      CLOSE (1)
c
c...Read The Unpaired OE Pairs
c
      tb(ntb-2:ntb) = 'foe'
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=tb(1:ntb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9003) i,j,noe
      CLOSE (1)
      tb(ntb-2:ntb) = 'poe'
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=200,
     *      form='unformatted',
     *      name=tb(1:ntb),
     *      readonly,
     *      recl=noe,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1) (poe(i,1),i=1,noe)
      READ (1,rec=2) (poe(i,2),i=1,noe)
      CLOSE (1)
      RETURN
c
c...Errors
c
  200 WRITE (*,9002) tb(1:ntb)
      CALL EXIT
      RETURN
      END
