      PROGRAM  ystat
c
c...Look At Statistics Of BYES File
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nmax = 1000*1000
      INTEGER
     *         buf(28), i, j, n, nlb, idx(NMAX), point(13)
      REAL
     *         rx(NMAX), ry(NMAX), sx, sxx, sy, syy, fract(6), qx(13),
     *         qy(13), tmp(NMAX), root2, sigma(13)
      CHARACTER*80
     *         lb
      DATA
     *    fract/0.38292, 0.68269, 0.86638, 0.95449, 0.98758, 0.99730/
c
 9001 FORMAT (' Enter ROOT: ' $)
 9002 FORMAT (q, a)
 9003 FORMAT (2i10)
 9004 FORMAT (' X=', f6.2, '+/-', f4.2, '   Y=', f6.2, '+/-', f4.2)
 9005 FORMAT (' Read ', i10, ' YES Pairs')
 9006 FORMAT ('Corrected By SQRT(2.0).  Units are microns.')
 9007 FORMAT ('Sorted Residuals - Value at various sigmas.')
 9008 FORMAT (i5, 3f10.2)
c
c...Initialize And Read BINF File
c
  100 WRITE (*,9001)
      READ  (*,9002) nlb,lb
      IF (nlb.le.0) GO TO 100
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb)//'.binf',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9003) i,n
      CLOSE (1)
      root2 = 0.01*SQRT(2.0)
c
c...Read BYES File
c
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      form='unformatted',
     *      name=lb(1:nlb)//'.byes',
     *      readonly,
     *      recl=28,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      DO i=1,n
        READ (1,rec=i) buf
        j = MOD(buf(28),20000)
        rx(i) = root2*(j-10000)
        j = buf(28)/20000
        ry(i) = root2*(j-10000)
      ENDDO
      CLOSE (1)
      WRITE (*,9005) n
c
c...Simple Statistics
c
      sx = 0.0
      sxx = 0.0
      sy = 0.0
      syy = 0.0
      DO i=1,n
        sx = sx + rx(i)
        sxx = sxx + rx(i)*rx(i)
        sy = sy + ry(i)
        syy = syy + ry(i)*ry(i)
      ENDDO
      sx = sx/n
      sxx = SQRT(sxx/n - sx*sx)
      sy = sy/n
      syy = SQRT(syy/n - sy*sy)
      WRITE (*,9006)
      WRITE (*,9004) sx,sxx,sy,syy
c
c...Median
c
      point( 1) = 0.5*(1.0 - fract(6))*n + 1
      point( 2) = 0.5*(1.0 - fract(5))*n + 1
      point( 3) = 0.5*(1.0 - fract(4))*n + 1
      point( 4) = 0.5*(1.0 - fract(3))*n + 1
      point( 5) = 0.5*(1.0 - fract(2))*n + 1
      point( 6) = 0.5*(1.0 - fract(1))*n + 1
      point( 7) = 0.5*(1.0           )*n + 1
      point( 8) = 0.5*(1.0 + fract(1))*n + 1
      point( 9) = 0.5*(1.0 + fract(2))*n + 1
      point(10) = 0.5*(1.0 + fract(3))*n + 1
      point(11) = 0.5*(1.0 + fract(4))*n + 1
      point(12) = 0.5*(1.0 + fract(5))*n + 1
      point(13) = 0.5*(1.0 + fract(6))*n + 1
      sigma( 1) = -3.0
      sigma( 2) = -2.5
      sigma( 3) = -2.0
      sigma( 4) = -1.5
      sigma( 5) = -1.0
      sigma( 6) = -0.5
      sigma( 7) =  0.0
      sigma( 8) =  0.5
      sigma( 9) =  1.0
      sigma(10) =  1.5
      sigma(11) =  2.0
      sigma(12) =  2.5
      sigma(13) =  3.0
      DO i=1,n
        tmp(i) = rx(i)
        idx(i) = i
      ENDDO
      CALL ruqsrt(n,tmp,idx)
      DO i=1,13
        qx(i) = tmp(point(i))
      ENDDO
      DO i=1,n
        tmp(i) = ry(i)
        idx(i) = i
      ENDDO
      CALL ruqsrt(n,tmp,idx)
      DO i=1,13
        qy(i) = tmp(point(i))
      ENDDO
      WRITE (*,9007)
      DO i=1,13
        WRITE (*,9008) i,sigma(i),qx(i),qy(i)
      ENDDO
      CALL EXIT
      END
