      SUBROUTINE  pairread(mode)
c
c...Look In 2M Directory And Read The PAIR/FIT Files
c
      INCLUDE
     *            'assemble.inc'
      CHARACTER*2
     *             suffix(NTEST), qprefix(6)
      CHARACTER*1
     *             prefix(NTEST)
      CHARACTER*64
     *             lb, tb, dir, s1, s2
      INTEGER
     *             ndir, nlb, ntb, i, j, from1(NTEST), from2(NTEST),
     *             in1, in2, out, ns1, ns2, mode
      DATA
     *   suffix/'xx', 'xx', 'xx', 'sj', 'sj', 'sj', 'sf', 'sf', 'sf',
     *          'sn', 'sn', 'sn', 'sf', 'sn', 'sn'/
     *   prefix/ 'x',  'x',  'x',  'j',  'h',  'k',  'j',  'h',  'k',
     *           'j',  'h',  'k',  'x',  'x',  'x'/
     *  qprefix/'hj', 'hk', 'jk', 'sj', 'sj', 'sf'/
      DATA
     *  from1/2, 2, 1, 1, 2, 3, 1, 2, 3, 1, 2, 3, 4, 4, 5/,
     *  from2/1, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 6, 5, 6, 6/
c
 9001 FORMAT (i2, i10)
 9002 FORMAT (i2, 2(1x,e15.8))
 9003 FORMAT (' Too Many Stars ', 2i10, ' >>', a)
 9004 FORMAT (' Fatal OPEN/READ Error In PAIRREAD ', a)
 9005 FORMAT (' >>', a, '<< NP(total)=', i8)
 9006 FORMAT (q, a)
c
c...Assemble Directory
c
  100 IF (mode.eq.0) THEN
        dir = '/uz6/xpmm/2m'//root(1:nroot)//'/'
        ndir = 12 + nroot + 1
      ELSE
        dir = '/uz6/xpmm/aux2mass/'
        ndir = 19
      ENDIF
      npq = 0
c
c...Test All Possible Combinations
c
      DO i=1,NTEST
        npair(i) = -1
        IF (i.le.3) THEN
          lb = dir(1:ndir)//qprefix(i)//root(1:nroot)//'.fit'
          nlb = ndir + nroot + LEN(qprefix(i)) + 4
        ELSEIF (i.le.12) THEN
          lb = dir(1:ndir)//prefix(i)//root(1:nroot)//suffix(i)//'.fit'
          nlb = ndir + LEN(prefix(i)) + nroot + LEN(suffix(i)) + 4
        ELSE
          lb = dir(1:ndir)//qprefix(i-9)//root(1:nroot)//suffix(i)//
     *         '.fit'
          nlb = ndir + LEN(qprefix(i-12)) + nroot + LEN(suffix(i)) + 4
        ENDIF
        CALL f_doenv(lb(1:nlb),ntb,tb)
c
c...Read The FIT and PAR Files
c
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        err=110,
     *        form='formatted',
     *        name=tb(1:ntb),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        READ (1,9006) ns1,s1
        READ (1,9006) ns2,s2
        IF (i.eq.3) THEN
          source(1) = s1
          nsource(1) = ns1
          source(3) = s2
          nsource(3) = ns2
        ELSEIF (i.eq.4) THEN
          source(4) = s2
          nsource(4) = ns2
        ELSEIF (i.eq.5) THEN
          source(2) = s1
          nsource(2) = ns1
        ELSEIF (i.eq.7) THEN
          source(5) = s2
          nsource(5) = ns2
        ELSEIF (i.eq.10) THEN
          source(6) = s2
          nsource(6) = ns2
        ENDIF
        READ (1,9001) ncoef(i),npair(i)
        DO j=1,ncoef(i)
          READ (1,9002) j,xcoef(j,i),ycoef(j,i)
        ENDDO
        CLOSE (1)
        IF (npair(i).gt.NSMAX) THEN
          WRITE (*,9003) npair(i),NSMAX,tb(1:ntb)
          npair(i) = -1
          GO TO 110
        ENDIF
        tb(ntb-2:ntb) = 'par'
        OPEN (
     *        access='direct',
     *        carriagecontrol='none',
     *        convert='big_endian',
     *        dispose='keep',
     *        err=200,
     *        form='unformatted',
     *        name=tb(1:ntb),
     *        readonly,
     *        recl=npair(i),
     *        recordtype='fixed',
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        READ (1,rec=1) (pair1(j),j=1,npair(i))
        READ (1,rec=2) (pair2(j),j=1,npair(i))
        CLOSE (1)
c
c...Store Them In The Total Pairs List
c
        DO j=1,npair(i)
          in1 = from1(i)*SMULT + pair1(j)
          in2 = from2(i)*SMULT + pair2(j)
          npq = npq+1
          p1(npq) = in1
          q1(npq) = in2
        ENDDO
        WRITE (*,9005) lb(1:nlb),npq
c
c...End Of Loops
c
  110   CONTINUE
      ENDDO
      RETURN
c
c...You Better Not Get Here
c
  200 WRITE (*,9004) tb(1:ntb)
      CALL EXIT
      END
