      SUBROUTINE  relread
c
c...Read The Binary REL File
c
      INCLUDE
     *            'decode.inc'
      INTEGER
     *            n, nlb, i, j, k, IARGC
      CHARACTER*64
     *            lb
c
 9001 FORMAT (' Enter Root: ' $)
 9002 FORMAT (q, a)
 9003 FORMAT (' Cannot Open ', a)
 9004 FORMAT (3x, q, a)
 9005 FORMAT (4i10, q, a)
 9006 FORMAT (' N(Pair)=', i10)
 9007 FORMAT (i2)
c
c...Get File Name And Open It
c
      n = IARGC()
  100 IF (n.gt.0) THEN
        CALL getarg(1,lb)
        nlb = 0
        DO n=1,LEN(lb)
          IF (lb(n:n).le.' ') THEN
            GO TO 110
          ELSE
            nlb = nlb+1
          ENDIF
        ENDDO
  110   n = 0
      ELSE
        WRITE (*,9001)
        READ  (*,9002,err=100,end=210) nlb,lb
      ENDIF
      lb(nlb+1:nlb+7) = 'rel.inf'
      nlb = nlb+7
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9005) n,nfind,nrec,smult,nroot,root
      DO i=1,6
        READ (1,9004) nsource(i),source(i)
      ENDDO
      CLOSE (1)
c
c...Cuteness To Make Human Lables Legible
c
      nof = 1
      DO i=1,6
        WRITE (label(i),9007) i
        j = INDEX(source(i)(1:nsource(i)),':')+1
        k = INDEX(source(i)(1:nsource(i)),root(1:nroot))-1
        IF ((k-j).eq.0) THEN
          label(i) = ' '//source(i)(j:j)
        ELSEIF ((k-j).gt.0) THEN
          label(i) = source(i)(j:j+1)
        ENDIF
        IF (label(i).eq.'sf') THEN
          nof = 0
        ENDIF
      ENDDO
c
c...Read The DAT File
c
      lb(nlb-2:nlb) = 'dat'
      OPEN (
     *      access='direct',
     *      carriagecontrol='none',
     *      convert='big_endian',
     *      dispose='keep',
     *      err=200,
     *      form='unformatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      recl=n,
     *      recordtype='fixed',
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,rec=1) (abuf(i),i=1,n)
      CLOSE (1)
      WRITE (*,9006) nfind
c
c...Split Into The Various Pieces
c
      j = 0
      DO i=1,nfind
        j = j+1
        nfrst(i) = abuf(j)
      ENDDO
      DO i=1,nfind
        j = j+1
        nlast(i) = abuf(j)
      ENDDO
      DO i=1,nrec
        j = j+1
        relcat(i) = abuf(j)/smult
        relno(i)  = abuf(j) - relcat(i)*smult
      ENDDO
c
c...Other Initializations
c
      DO i=1,nrec
        field(i) = -1
        pmmno(i) = -1
        ra(i) = -1
        dec(i) = -1
        mag(i) = -1
      ENDDO
      RETURN
c
c...Errors
c
  200 WRITE (*,9003) lb(1:nlb)
      GO TO 100
  210 CALL EXIT
      END
