      SUBROUTINE  iterfit(pr,xx,yy,mm,zz, zcoef,sigmaz)
c
c...Fit Pairs To Mean
c
      INCLUDE
     *            'magover.inc'
      DOUBLE PRECISION
     *            zcoef(*), szcoef(NCMAX), sigmaz, x, y, z, chisq, zc,
     *            zr, m
      INTEGER
     *            xx(*), yy(*), mm(*), zz(*), pr(*), i, j, k, ising
c
 9001 FORMAT (' Singular Matrix In ITERFIT')
c
c...Initialization
c
  100 DO i=1,ncoef
        zlhs(i) = 0.0D00
        DO j=1,ncoef
          zrhs(i,j) = 0.0D00
        ENDDO
      ENDDO
      chisq = 0.0
      sigmaz = TAG
c
c...Accumulation
c
      DO i=1,npair
        x = xx(pr(i))/SCALE
        y = yy(pr(i))/SCALE
        m = 0.01D00*MOD(mm(pr(i)),10000)
        z = zz(i)/SCALE
        CALL filldv(x,y,m)
        DO j=1,ncoef
          zlhs(j) = zlhs(j) + dv(j)*z
          DO k=1,ncoef
            zrhs(j,k) = zrhs(j,k) + dv(j)*dv(k)
          ENDDO
        ENDDO
      ENDDO
c
c...Inversion
c
      CALL matinv(ising)
      IF (ising.ne.0) THEN
        WRITE (*,9001)
        RETURN
      ENDIF
c
c...Coefficients
c
      DO i=1,ncoef
        zcoef(i) = 0.0D00
        DO j=1,ncoef
          zcoef(i) = zcoef(i) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Residuals And ChiSquared
c
      DO i=1,npair
        x = xx(pr(i))/SCALE
        y = yy(pr(i))/SCALE
        m = 0.01D00*MOD(mm(pr(i)),10000)
        z = zz(i)/SCALE
        CALL filldv(x,y,m)
        zc = 0.0D00
        DO j=1,ncoef
          zc = zc + zcoef(j)*dv(j)
        ENDDO
        zr = z-zc
        chisq = chisq + zr*zr
      if (i.le.5) then
      write (*,9991) i,pr(i),xx(pr(i)),yy(pr(i)),zz(i)
      endif
 9991 format (6i12)
      ENDDO
      sigmaz = SQRT(chisq/(npair-(ncoef+1)))
c
c...Correct For Only 2 Plates
c
      sigmaz = sigmaz*SQRT(2.0D00)
c
c...Errors
c
      DO i=1,ncoef
        szcoef(i) = sigmaz*SQRT(zrhs(i,i))
      ENDDO
c
c...Convert To User's Units
c
      sigmaz = SCALE*sigmaz
      RETURN
      END
