      SUBROUTINE  pairfind
c
c...Look In Sorted Lists For Pairs
c
      INCLUDE
     *            'magover.inc'
      PARAMETER
     *            nqmax = 100
      INTEGER
     *            get, low, high, r, xl, xh, nfind, verbose,
     *            ifind(NQMAX), jfind(NQMAX), test, yl, m1, m2,
     *            yh, yt
      REAL
     *            dx, dy, dr, rfind(NQMAX), z, rsqr
c
 9001 FORMAT (' PAIRFIND Found ', i7, ' Pairs')
c
c...Initialization
c
  100 get = 0
      npair = 0
      low = 1
      high = 1
      r = rmicron*100.0D00 + 0.5D00
      rsqr = (r/SCALE)**2
c
c...Outer Loop Over (1) Index
c
  110 get = get+1
      IF (get.gt.n1) THEN
        WRITE (*,9001) npair
        RETURN
      ENDIF
      xl = x1(get) - r
      xh = x1(get) + r
      yl = y1(get) - r
      yh = y1(get) + r
      verbose = 0
      IF (verbose.eq.1) THEN
      write (*,9991) id1(get),get,xl,xh,yl,yh
 9991 format (7i11)
      ENDIF
c
c...Inner Loop Brackets (2)
c
  120 CONTINUE
      IF (x2hat(low).lt.xl) THEN
        IF (low.lt.n2) THEN
          low = low+1
          GO TO 120
        ENDIF
      ENDIF
      IF (x2hat(low).gt.xh) GO TO 110
      IF (high.lt.low) THEN
        high = low
      ENDIF
      IF (verbose.ne.0) THEN
      write (*,9991) low,x2hat(low)
      ENDIF
  130 CONTINUE
      IF (high.lt.n2) THEN
        IF (x2hat(high+1).le.xh) THEN
          high = high+1
          GO TO 130
        ENDIF
      ENDIF
      IF (verbose.ne.0) THEN
      write (*,9991) high,x2hat(high)
      ENDIF
c
c...Test All Entries In This Range
c
      nfind = 0
      DO test=low,high
        IF (verbose.ne.0) THEN
        dx = ((x2hat(test)-x1(get))/SCALE)**2
        dy = ((y2hat(test)-y1(get))/SCALE)**2
        dr = dx+dy
        write (*,9991) x2hat(test),y2hat(test),idx(test),
     * x2(idx(test)),y2(idx(test))
        write (*,9992) test,dx,dy,dr,rsqr
 9992 format (i11, 4(1x,1pe10.3))
        ENDIF
        yt = y2hat(test)
        IF ((yt.ge.yl).and.(yt.le.yh)) THEN
          dy = ((yt-y1(get))/SCALE)**2
          IF (dy.le.rsqr) THEN
            dx = ((x2hat(test)-x1(get))/SCALE)**2
            dr = dx+dy
            IF (dr.le.rsqr) THEN
              IF (nfind.lt.NQMAX) THEN
                nfind = nfind+1
                ifind(nfind) = get
                jfind(nfind) = idx(test)
                rfind(nfind) = dr
 9999           rfind(nfind) = MOD(d2(idx(test)),10000)
                IF (verbose.ne.0) THEN
      write (*,9995) nfind,d1(get),d2(idx(test)),rfind(nfind)
                pause
 9995 format (' Found ', 3i11, 1x, 1pe10.3)
                ENDIF
              ENDIF
            ENDIF
          ENDIF
        ENDIF
      ENDDO
c
c...Save Pairs
c
      IF (nfind.gt.0) THEN
        npair = npair+1
        pair1(npair) = ifind(1)
        pair2(npair) = jfind(1)
        z = rfind(1)
        DO test=2,nfind
          IF (rfind(test).lt.z) THEN
            pair1(npair) = ifind(test)
            pair2(npair) = jfind(test)
            z = rfind(test)
          ENDIF
        ENDDO
      ENDIF
c
c...Loop Until Completion.  RETURN Is On GET
c
      GO TO 110
      END
