      SUBROUTINE  domongo
c
c...Stroke MONGO To X
c
      INCLUDE
     *            'xp6.inc'
      PARAMETER
     *            nx = 30,
     *            ny = 30,
     *            nlmax = 50
      INTEGER
     *            i, j, nlb, ntb, nz, nqb
      CHARACTER*16
     *            xlab, ylab
      REAL
     *            xbar, xwid, ybar, ywid, x1, x2, y1, y2,
     *            level(NLMAX), z0, dz, zpmin, zpmax,
     *            cd(NX,NY), dd(NX,NY)
      CHARACTER*72
     *             lb, tb, qb
c
 9001 FORMAT ('ZMin=', 1pe10.3, '  ZMax=', 1pe10.3,
     *        'Enter NLevel,Z0,DZ:')
 9002 FORMAT (i5, 2f10.0)
c
c...Copy From FORTRAN To MONGO
c
  100 IF (np.le.0) THEN
        CALL x_fortwrite('No Points To Plot')
        RETURN
      ENDIF
      CALL label(xid,xlab)
      CALL label(yid,ylab)
      DO i=LEN(xlab),1,-1
        IF (xlab(i:i).gt.' ') GO TO 110
      ENDDO
      i = 0
  110 DO j=LEN(ylab),1,-1
        IF (ylab(j:j).gt.' ') GO TO 120
      ENDDO
      j = 0
  120 lb = root(1:nroot)//'    '//ylab(1:j)//
     *     ' as a function of '//xlab(1:i)
      nlb = nroot + 4 + j + 18 + i
c
c...Subroutine Call to MONGO
c
      IF (laser.ne.0) THEN
        CALL mgosetup(-7)
        CALL mgoprntinit
      ELSE
        CALL mgosetup(7)
      ENDIF
      CALL mgoerase
      CALL mgosetltype(0)
      CALL mgosetlweight(1)
      CALL mgosetangle(0.0)
      CALL mgosetexpand(1.0)
      IF (uselim.eq.0) THEN
        xpmin = xp(1)
        xpmax = xp(1)
        ypmin = yp(1)
        ypmax = yp(1)
        DO i=2,np
          xpmin = MIN(xpmin,xp(i))
          xpmax = MAX(xpmax,xp(i))
          ypmin = MIN(ypmin,yp(i))
          ypmax = MAX(ypmax,yp(i))
        ENDDO
        xbar = 0.5*(xpmax+xpmin)
        xwid = 0.5*(xpmax-xpmin)
        ybar = 0.5*(ypmax+ypmin)
        ywid = 0.5*(ypmax-ypmin)
        x1 = xbar - 1.02*xwid
        x2 = xbar + 1.02*xwid
        y1 = ybar - 1.02*ywid
        y2 = ybar + 1.02*ywid
      ELSE
        x1 = xpmin
        x2 = xpmax
        y1 = ypmin
        y2 = ypmax
      ENDIF
c
c...Special Logic For Square
c
      IF (square.ne.0) THEN
        dz = MAX(x2-x1,y2-y1)
        x2 = x1+dz
        y2 = y1+dz
      ENDIF
c
c...Special Logic For Contour Diagram
c
      IF (contour.ne.0) THEN
        CALL congen(NX,NY,x1,y1,x2,y2,cd,dd,zpmin,zpmax)
  130   WRITE (tb,9001) zpmin,zpmax
        CALL x_fortpop(tb(1:59),nqb,qb)
        IF (nqb.lt.0) RETURN
        IF (nqb.eq.0) GO TO 130
        READ (qb(1:nqb),9002,err=130) nz,z0,dz
        nz = MIN(nz,NLMAX)
        IF ((nz.le.0).or.(dz.eq.0.0)) GO TO 110
        DO i=1,nz
          level(i) = z0 + (i-1)*dz
        ENDDO
        x1 = 1
        x2 = nx
        y1 = 1
        y2 = ny
        CALL mgosetlim(x1,y1,x2,y2)
        CALL mgobox(1,2)
        CALL mgoxlabel(nlb,lb)
        CALL mgocontour(cd,NX,NY,level,nz)
c
c...Logic For Vector
c
      ELSEIF (vector.ne.0) THEN
        CONTINUE
c
c...Logic For Points
c
      ELSE
        CALL mgosetlim(x1,y1,x2,y2)
        CALL mgobox(1,2)
        CALL mgoxlabel(nlb, lb)
        IF (bigdot.ne.0) THEN
          CALL mgopoints(43.0,1, xp,yp,np)
        ELSE
          CALL mgopoints(10.0,1, xp,yp,np)
        ENDIF
      ENDIF
c
c...Common Processing For Exit
c
      IF (grid.ne.0) THEN
        CALL mgogrid(0)
      ENDIF
      IF (laser.ne.0) THEN
        CALL mgoprntplot(i)
      ELSE
        CALL mgotidle
      ENDIF
      RETURN
      END
