      SUBROUTINE  aberration(iyy,idn,ihh,imm,iss, alpha,delta, ax,ay)
c
c...Compute Corrections Due To Aberration
c
      IMPLICIT
     *            NONE
      REAL
     *            alpha, delta, ax, ay
      INTEGER
     *            iyy, idn, ihh, imm, iss, iload
      REAL*8
     *            zalpha, zdelta, sa, ca, sd, cd, ut, rcor, dcor,
     *            degrad, timrad, aberr, slon, clon, sobl, cobl,
     *            dist
      DATA
     *            iload/0/,
     *            aberr/20.496D00/
c
c...OneTime Initialization
c
      IF (iload.eq.0) THEN
        iload = 1
        degrad = ATAN(1.0D00)/45.0D00
        timrad = 15.0D00*degrad
      ENDIF
c
c...Compute Various SIN/COS
c
      zalpha = alpha
      zdelta = delta
      sa = SIN(zalpha*timrad)
      ca = COS(zalpha*timrad)
      sd = SIN(zdelta*timrad)
      cd = COS(zdelta*timrad)
      CALL getsun(iyy,idn,ihh,imm,iss, slon,clon, sobl,cobl, dist)
c
c...Compute Corrections
c
      rcor = slon*sa + clon*ca*cobl
      dcor = (cobl*clon)*(sobl*cd/cobl - sa*sd) + slon*sd*ca
      ax = (-aberr*rcor)/(54000.0D00*cd)
      ay = (-aberr*dcor)/3600.0D00
      RETURN
      END
