      SUBROUTINE getpf(iyy,idn,ihh,imm,iss, alpha,delta, pfx,pfy)
c
c...This computes the JD, the fractional year, and the parallax factors
c
      IMPLICIT
     *           NONE
      REAL
     *           alpha, delta, pfx, pfy
      INTEGER
     *           iyy, idn, ihh, imm, iss, iload
      REAL*8
     *           zalpha, zdelta, sa, ca, sd, cd, se, ce, sl, cl,
     *           dist, degrad, timrad
      DATA
     *           iload/0/
c
c...One Time Initialization
c
      IF (iload.eq.0) THEN
        iload = 1
        degrad = ATAN(1.0D00)/45.0D00
        timrad = 15.0D00*degrad
      ENDIF
      zalpha = alpha
      zdelta = delta
      sa = SIN(zalpha*timrad)
      ca = COS(zalpha*timrad)
      sd = SIN(zdelta*degrad)
      cd = COS(zdelta*degrad)
c
c...Compute Anomalies and Parallax Factors
c
      CALL getsun(iyy,idn,ihh,imm,iss, sl,cl, se,ce, dist)
      pfx = dist*(ce*ca*sl - sa*cl)
      pfy = dist*((se*cd - ce*sa*sd)*sl - ca*sd*cl)
c
      RETURN
      END
