      subroutine nclip(mode,mkeep)
c
c...this routine chops the residuals by number, not size
c
      include 'pa6inc1.inc'
      parameter (lkeep=10, kkeep=lkeep+1)
      dimension rpass(kkeep), ipass(kkeep,2)
c
 9201 FORMAT (19H0NCLIP IS REMOVING , I2, 8H STAR(S))
 9202 FORMAT (7H ISTAR=, I5, 10H   IPLATE=, I4, 9H   RESID=, F10.6)
c
c
c...mode=1 clips on x residual
c   mode=2 clips on y residual
c   mode=3 clips on total residual
c   mode=4 clips on x and/or y residual
c
      if ((mode.lt.1).or.(mode.gt.4)) return
      nkeep=mkeep
      if (nkeep.gt.lkeep) nkeep=lkeep
      nin=0
c
      do 160 istar=1,nstar
      if (instar(istar).eq.0) go to 160
      do 150 iplate=1,nplate
      x=xresid(istar,iplate)
      y=yresid(istar,iplate)
      w=tag
      z=tag
      if ((x.eq.tag).and.(y.eq.tag)) go to 150
      if ((x.ne.tag).and.(y.eq.tag)) w=x
      if ((x.eq.tag).and.(y.ne.tag)) w=y
      if (w.ne.tag) go to 100
      w=x
      if (abs(y).gt.abs(x)) w=y
      z=sqrt(x*x + y*y)
  100 go to (110,120,130,140),mode
c
  110 if (x.eq.tag) go to 150
      call stack(nin,x,istar,iplate,rpass,ipass,nkeep)
      go to 150
  120 if (y.eq.tag) go to 150
      call stack(nin,y,istar,iplate,rpass,ipass,nkeep)
      go to 150
  130 if (z.eq.tag) go to 150
      call stack(nin,z,istar,iplate,rpass,ipass,nkeep)
      go to 150
  140 if (w.eq.tag) go to 150
      call stack(nin,w,istar,iplate,rpass,ipass,nkeep)
  150 continue
  160 continue
c
      write (2,9201,iostat=junk) nin
      if (nin.le.0) return
      do 210 i=1,nin
      istar=ipass(i,1)
      iplate=ipass(i,2)
      write (2,9202,iostat=junk) looks(istar),iplate,rpass(i)
      xcoord(istar,iplate)=tag
      ycoord(istar,iplate)=tag
      xresid(istar,iplate)=tag
      yresid(istar,iplate)=tag
      xcalc(istar,iplate)=tag
      ycalc(istar,iplate)=tag
  210 continue
      return
      end
