      SUBROUTINE  newpfzd(ieyy,iedn,iehh,iemm,iess,iflt,itel)
c
c...Recompute Parallax Factor/Zenith Distance If Possible
c
      INCLUDE
     *            'pa6inc1.inc'
      DIMENSION
     *            ieyy(*), iedn(*), iehh(*), iemm(*), iess(*),
     *            iflt(*), itel(*)
      DATA
     *            iusno/'NO61'/, ikpno/'KP4M'/
c
 9101 FORMAT (' Standard Plate: ', i2,':',i3,3(':',i2),
     *        '   RA=', f10.7, '/Dec=', f10.6, '   Mu=', f6.3,
     *        '@', f5.1)
 9201 FORMAT ('1STANDARD PLATE IS PLATE NUMBER: ', i4)
 9202 FORMAT ('1STANDARD PLATE IS WEIGHTED MEAN')
 9203 FORMAT ('0EPOCH: ', i2,':',i3,3(':',i2),
     *        '   RA=', f10.7, '/DEC=', f10.6, '   MU=', f6.3,
     *        '@', f5.1)
 9204 FORMAT ('0RECOMPUTING PARALLAX FACTORS AND ZENITH DISTANCES')
 9205 FORMAT (' P#',i4, '  T=',I2,':',I3,3(':',i2),
     *        '  PX,Y=', f8.5,',',f8.5,
     *        '  ZX,Y=', f8.5,',',f8.5,
     *        1x, a4)
c
c...If Any Year Field Is ZERO, assume old format title cards
c
  100 DO i=1,nplate
        IF (ieyy(i).eq.0) RETURN
      ENDDO
c
c...If Standard Plate Is Selected, Use It.  Otherwise Take Mean
c
      IF ((ipick.gt.0).and.(ipick.le.nplate)) THEN
        jyy = ieyy(ipick)
        jdn = iedn(ipick)
        jhh = iehh(ipick)
        jmm = iemm(ipick)
        jss = iess(ipick)
        WRITE (2,9201,iostat=junk) lookp(ipick)
      ELSE
        st = 0.0
        sw = 0.0
        DO i=1,nplate
          st = st + wplate(i)*tplate(i)
          sw = sw + wplate(i)
        ENDDO
        st = st/sw
        jyy = st
        IF ((mod(jyy,4).eq.0).and.(mod(jyy,200).ne.0)) THEN
          st = 366.0*(st - jyy) + 1.0
        ELSE
          st = 365.0*(st - jyy) + 1.0
        ENDIF
        jdn = st
        st = 24.0*(st - jdn)
        jhh = st
        st = 60.0*(st - jhh)
        jmm = st
        jss = 60.0*(st - jmm)
        WRITE (2,9202,iostat=junk)
      ENDIF
      WRITE (*,9101) jyy,jdn,jhh,jmm,jss,ra,dec,pmmu,pmth
      WRITE (2,9203,iostat=junk) jyy,jdn,jhh,jmm,jss,ra,dec,pmmu,pmth
      WRITE (2,9204,iostat=junk)
c
c...Recompute Parallax Factors And Zenith Distances
c
      CALL getpfzd(0, jyy,jdn,jhh,jmm,jss, ra,dec,pmmu,pmth)
      DO i=1,nplate
        IF (itel(i).eq.iusno) THEN
          j=1
        ELSEIF (itel(i).eq.ikpno) THEN
          j=2
        ELSE
          j=0
        ENDIF
        CALL getpfzd(j, ieyy(i),iedn(i),iehh(i),iemm(i),iess(i),
     *               parfx(i),parfy(i),pzdx(i),pzdy(i))
        WRITE (2,9205,iostat=junk) lookp(i),ieyy(i),iedn(i),iehh(i),
     *                             iemm(i),iess(i),parfx(i),parfy(i),
     *                             pzdx(i),pzdy(i),itel(i)
      ENDDO
      RETURN
      END
