      subroutine outpc
c
c...this prints the plate constants
c
c	data statement must agree with termpc to avoid confusion
c
      include 'pa6inc1.inc'
      real*8 ltitle(lc)
      data ltitle/5hconst, 5h  x  , 5h  y  , 5h x*x , 5h x*y , 5h y*y ,
     *   5h  m  , 5h m*m , 5h m*x , 5h m*y , 5hm*x*x, 5hm*x*y, 5hm*y*y,
     *   5h  c  , 5h c*c , 5h c*x , 5h c*y , 5hc*x*x, 5hc*x*y, 5hc*y*y,
     *   5hx*x*x, 5hx*x*y, 5hx*y*y, 5hy*y*y/
      data iload/0/
c
 9201 FORMAT (21H0PLATE CONSTANTS FOR , 10A1)
 9202 FORMAT (6H0TERM , I2, 4H   (, A5, 1H))
 9203 FORMAT (7H PLATE=, I4)
 9204 FORMAT (7H PLATE=, I4, 8H  XCOEF=, 1PE12.5, 9H  XSIGMA=,
     * 1pe12.5, 9h  xratio=, 0pf8.1)
 9205 FORMAT (7H PLATE=, I4, 63X, 9H   YCOEF=, 1PE12.5, 9H  YSIGMA=,
     * 1pe12.5, 9h  yratio=, 0pf8.1)
 9206 FORMAT (7H PLATE=, I4, 8H  XCOEF=, 1PE12.5, 9H  XSIGMA=,
     * 1pe12.5, 9h  xratio=, 0pf8.1, 5x, 9h   ycoef=, 1pe12.5,
     * 9h  ysigma=, 1pe12.5, 9h  yratio=, 0pf8.1)
 9207 FORMAT (1H0, 11X, 56(1HX), 8X, 56(1HY))
 9208 FORMAT (7H PLATE=, I4,
     *        5h  sx=, 1pe13.6, 3h+/-, 1pe8.2,
     *        5h  tx=, 1pe13.6, 3h+/-, 1pe8.2,
     *        5h  sy=, 1pe13.6, 3h+/-, 1pe8.2,
     *        5h  ty=, 1pe13.6, 3h+/-, 1pe8.2)
 9209 FORMAT (37H0PLATE SCALE(S) AND ROTATION ANGLE(T))
 9210 FORMAT (6X, 5H  Sx=, f9.6, 5H  Tx=, f9.5, 7H  Sx-y=,
     * f9.6, 1h(, f4.1, 8h)  tx-y=, f8.5, 1h(, f4.1, 1h))
c
      if (iload.ne.0) go to 100
      iload=1
      raddeg=45.0/atan(1.0)
c
c...examine all coefficients and ignore those that are not used
c
  100 write (2,9201,iostat=junk) (ititle(l),l=1,lt)
      write (2,9207,iostat=junk)
      nfit=nxfit
      if (nyfit.gt.nxfit) nfit=nyfit
      do 300 ifit=1,nfit
      j=0
      if (ifit.gt.nxfit) go to 120
      do 110 iplate=1,nplate
      if (inxfit(ifit,iplate).eq.1) j=1
  110 continue
  120 if (nfit.gt.nyfit) go to 140
      do 130 iplate=1,nplate
      if (inyfit(ifit,iplate).eq.1) j=1
  130 continue
  140 if (j.eq.0) go to 300
c
c...print those that are used
c
      write (2,9202,iostat=junk) ifit,ltitle(ifit)
      do 260 jplate=1,nplate
      iplate = ipsort(jplate)
      j=0
      k=0
      if (ifit.gt.nxfit) go to 210
      if (inxfit(ifit,iplate).ne.1) go to 210
      xo1=pconx(ifit,iplate)
      xo2=0.0
      xo3=0.0
      j=1
      xo2=spconx(ifit,iplate)
      xo3=0.0
      if (xo2.gt.0.0) xo3=ABS(xo1/xo2)
  210 if (ifit.gt.nyfit) go to 220
      if (inyfit(ifit,iplate).ne.1) go to 220
      yo1=pcony(ifit,iplate)
      yo2=0.0
      yo3=0.0
      k=1
      yo2=spcony(ifit,iplate)
      yo3=0.0
      if (yo2.gt.0.0) yo3=ABS(yo1/yo2)
  220 if (ifit.eq.1) then
        xo1=xo1 + plcntx(iplate)
        yo1=yo1 + plcnty(iplate)
      endif
      if ((j.eq.1).and.(k.eq.0)) go to 230
      if ((j.eq.0).and.(k.eq.1)) go to 240
      if ((j.eq.1).and.(k.eq.1)) go to 250
      write (2,9203,iostat=junk) lookp(iplate)
      go to 260
  230 write (2,9204,iostat=junk) lookp(iplate),xo1,xo2,xo3
      go to 260
  240 write (2,9205,iostat=junk) lookp(iplate),yo1,yo2,yo3
      go to 260
  250 write (2,9206,iostat=junk) lookp(iplate),xo1,xo2,xo3,yo1,yo2,yo3
  260 continue
  300 continue
c
c...compute scale/rotation from linear terms in x and y.
c
  400 write (2,9209,iostat=junk)
      do 430 iplate=1,nplate
      x01=tag
      x02=tag
      x03=tag
      x04=tag
      y01=tag
      y02=tag
      y03=tag
      y04=tag
c
      if  ((inxfit(2,iplate).ne.  1)
     * .or.(inxfit(3,iplate).ne.  1)
     * .or.( pconx(2,iplate).eq.tag)
     * .or.( pconx(3,iplate).eq.tag)) go to 410
      x01=sqrt(pconx(2,iplate)**2 + pconx(3,iplate)**2)
      x03=raddeg*atan2(pconx(3,iplate),pconx(2,iplate))
      if (x03.lt.0.0) x03=x03 + 360.0
      if (( spconx(2,iplate).eq.tag)
     * .or.(spconx(3,iplate).eq.tag)
     * .or.(         x01*x01.le.0.0)) go to 410
      x02=       sqrt((pconx(2,iplate)*spconx(2,iplate))**2
     *              + (pconx(3,iplate)*spconx(3,iplate))**2)/x01
      x04=raddeg*sqrt((pconx(2,iplate)*spconx(3,iplate))**2
     *              + (pconx(3,iplate)*spconx(2,iplate))**2)/(x01*x01)
c
  410 if  ((inyfit(2,iplate).ne.  1)
     * .or.(inyfit(3,iplate).ne.  1)
     * .or.( pcony(2,iplate).eq.tag)
     * .or.( pcony(3,iplate).eq.tag)) go to 420
      y01=sqrt(pcony(2,iplate)**2 + pcony(3,iplate)**2)
      y03=raddeg*atan2(pcony(3,iplate),pcony(2,iplate))
      if (y03.lt.0.0) y03=y03 + 360.0
      if  ((spcony(2,iplate).eq.tag)
     * .or.(spcony(3,iplate).eq.tag)
     * .or.(         y01*y01.le.0.0)) go to 420
      y02=       sqrt((pcony(2,iplate)*spcony(2,iplate))**2
     *              + (pcony(3,iplate)*spcony(3,iplate))**2)/y01
      y04=raddeg*sqrt((pcony(2,iplate)*spcony(3,iplate))**2
     *              + (pcony(3,iplate)*spcony(2,iplate))**2)/(y01*y01)
c
  420 if ((x01.eq.tag).and.(y01.eq.tag)) go to 430
      write (2,9208,iostat=junk) lookp(iplate),x01,x02,x03,x04,y01,y02,
     * y03,y04
      z01=x01-y01
      z02=sqrt(x02*x02 + y02*y02)
      if (z02.gt.0.0) z02=abs(z01)/z02
      z03=x03-y03
      if (z03.lt.  0.0) z03=z03 + 360.0
      if (z03.gt.180.0) z03=360.0 - z03
      z04=sqrt(x04*x04 + y04*y04)
      if (z04.gt.0.0) z04=abs(90.0-abs(z03))/z04
      write (2,9210,iostat=junk) x01,x03,z01,z02,z03,z04
  430 continue
c
      return
      end
