      SUBROUTINE  reader(iover)
c
c...Reads the data deck
c
c	Modified For WF/PC  29-Dec-88
c
c	Modified For Lots Of Stars 15-Jun-89
c
c	Modified For Non-Linear SetUp Cards 17-Jun-89
c
      INCLUDE
     *            'pa6inc1.inc'
      PARAMETER
     *            lv=2*ls, lmax=2*ls
      DIMENSION
     *            abv(lv), acv(lv), infv(lv), inrv(lv), inqv(lv),
     *            kpvect(lmax), ksvect(lmax)
      DIMENSION
     *            ieyy(lp), iedn(lp), iehh(lp), iemm(lp), iess(lp)
      REAL*4
     *            rs(ls), rp(lp)
      CHARACTER*1
     *            jbl(80), jblank, altformat
      CHARACTER*8
     *            phzd
      CHARACTER*132
     *            chcard
      EQUIVALENCE
     *            (abv(1),work2(1,1)),   (acv(1),work2(1,3)),
     *            (infv(1),work2(1,5)),  (inrv(1),work2(1,7)),
     *            (inqv(1),work2(1,9))
      DATA
     *            ifind/0/, jblank/' '/, iload/0/
c
 9001 FORMAT (a)
 9002 FORMAT (5i8, 5f6.2, 2x, a)
 9003 FORMAT (70z1)
 9004 FORMAT (i8, f7.2, 5f6.3, i2,i3,3i2, 2f10.4)
 9005 FORMAT (2i8, 2f10.0)
 9006 FORMAT (12f6.2)
 9007 FORMAT (3i4, 24i1, 24i1)
 9008 FORMAT (24i1, 24i1, i1)
 9009 FORMAT (10a1, 2f10.5, 2i5, 4f8.5, i2, a)
 9010 FORMAT ('1Reading data for ', 10a1)
 9011 FORMAT (' PLATE=', i3, ' T=', f6.3, ' XPF=', f6.3,
     * ' YPF=', f6.3, ' ZDX=', f6.3, ' ZDY=', f6.3, ' W=',
     * f5.2, ' XIN:', 24i1, ' YIN:', 24i1)
 9012 FORMAT ('0FLAGMN=', f10.2, '   FLAGMX=', f10.2, '    CONVL=',
     * f10.6, '   REJPCL=', f5.2, '    FDAMP=', F5.2 /)
 9013 FORMAT ('0STARS EXPLICITLY EXCLUDED:', 26(1x, i4))
 9014 format ('0STARS IMPLICITLY EXCLUDED:', '   MAG(MIN)=',
     * f5.2, '   MAG(MAX)=', f5.2, '   COL(MIN)=', f5.2,
     * '   COL(MAX)=', f5.2)
 9015 FORMAT (9i8)
 9016 FORMAT (i6, 4i3, 7f6.2, 2i3, 6x, a)
 9017 FORMAT (i4, i2, 2f10.4, 16x, f7.1, 1x, 2i3, 2f7.3, 9x, i6, 2f7.3)
 9018 FORMAT (i5, 2f10.3)
 9021 FORMAT (' Checking For Number Of Measurements...NUMMIN=', i3,
     *        '   NUMMAX=', i3)
 9022 FORMAT (' Removing Star ', i6, '   N=', i4)
c
c...Iteration logic to signal no more data to be read
c
c	MODIFIED:  Return Was +1
c
  100 IF (ifind.ne.0) THEN
        iover = -1
        RETURN
      ENDIF
      iover = 0
c
c...Reset the various arrays in memory before reading input data
c
      CALL reset
      DO i=1,lmax
         kpvect(i) = 0
         ksvect(i) = 0
      ENDDO
c
c...First card in deck is the star parameter card
c
c	(15-Jun-89) Code Selects On `` TITLE'' or ``*TITLE''
c
      IF (iload.eq.0) THEN
         iload = 1
         READ (1,9009) (ititle(i),i=1,lt),ra,dec,icorrect,iobsy,
     *                 zdslope,coloff,pmmu,pmth,numext,altformat
      ENDIF
      IF (altformat.eq.'*') THEN
        inform = 1
      ELSE
        inform = 0
      ENDIF
c
c...Special Title Card Processing Goes Here
c
      DO i=1,numext
        READ (1,9001) chcard
        CALL STR_UPCASE(chcard,chcard)
      ENDDO
c
c...Here is the general "next card" entry.  EOF means RETURN gracefully.
c
      READ (1,9001,end=110) chcard
      GO TO 120
  110 ifind = 1
      iover = -1
      icomb = 0
      RETURN
  120 CONTINUE
c
c============================================================================
c
c...Logic To Parse ENSEMBLE Directives
c
c	NOTE:  If an error occurs in READ, the logic assumes that the
c		card was actually the start of another data record.
c
c	NOTE:  Blank card means RETURN gracefully
c
      READ (chcard,9007,err=200) jfrst,jlast,ipick,
     *     (inxend(i),i=1,nefit),(inyend(i),i=1,nefit)
      IF ((jfrst.eq.0).and.(jlast.eq.0)) THEN
        ifind=0
        iover=-1
        icomb=0
        RETURN
      ENDIF
      nstar = jlast+1-jfrst
      READ (1,9003) (numfit(i),i=1,nstar)
      READ (1,9003) (infrst(i),i=1,nstar)
      READ (1,9003) (inrest(i),i=1,nstar)
      DO i=1,nstar
        looks(i)=i+1-jfrst
      ENDDO
      i = 0
      DO istar=1,nstar
        IF ((infrst(istar).eq.0).and.(inrest(istar).eq.1)) THEN
          i=i+1
          infv(i)=looks(istar)
        ENDIF
      ENDDO
      WRITE (2,9010,iostat=junk) (ititle(i),i=1,lt)
      WRITE (2,9014,iostat=junk) aamin,aamax,ccmin,ccmax
      IF (i.gt.0) THEN
         WRITE (2,9013,iostat=junk) (infv(j),j=1,i)
      ENDIF
      WRITE (2,9012,iostat=junk) flagmn,flagmx,convl,rejpcl,fdamp
      READ (1,9007,end=130)
      ifind = 0
      iover = 0
      icomb = 1
      RETURN
  130 ifind = 1
      iover = 1
      icomb = 1
      RETURN
c
c============================================================================
c
c...Logic To Parse DATA DECK
c
  200 ifind = 0
      iover = 0
      icomb = 0
c
c...Number of stars, etc., for a plate are read from the image in memory
c
      IF (inform.eq.0) THEN
        READ (chcard,9002) jfst,jlst,nplate,jparst,jpick,
     *                     convl,rejpcl,fdamp,aamin,aamax,phzd
        nummin = 0
        nummax = 0
        ccmin = 0.0
        ccmax = 0.0
        ixyflip = 0
        mstar = jlst+1-jfst
        IF ((jfst.le.0).or.(jlst.gt.lmax).or.(jfst.gt.jlst)) THEN
           STOP 'FORTRAN STOP...Star numbers are illegal!'
        ENDIF
      ELSEIF (inform.eq.1) THEN
        READ (chcard,9016) mstar,nplate,jparst,jpick,ixyflp,
     *                     convl,rejpcl,fdamp,aamin,aamax,ccmin,ccmax,
     *                     nummin,nummax,phzd
        IF (mstar.gt.LS) THEN
          STOP 'Too Many Stars For This Version'
        ENDIF
      ELSE
        STOP 'Unknown INFORM'
      ENDIF
c
c...Test For Application Of Photometric ZD Correction
c
      CALL STR_UPCASE(phzd,phzd)
      IF ((phzd.eq.'        ').or.(phzd.eq.'   SETUP')) THEN
        nophzd = 1
      ELSE
        nphhzd = 0
      ENDIF
c
c...Star Number Cards
c
      READ (1,9015) (looks(i),i=1,mstar)
c
c...Magnitude Card(s)
c
      READ (1,9006) (abv(i),i=1,mstar)
c
c...Color Card(s)
c
      READ (1,9006) (acv(i),i=1,mstar)
c
c...Fitting Flag Card(s)
c
      READ (1,9003) (inqv(i),i=1,mstar)
c
c...First Iteration Inclusion Card(s)
c
      READ (1,9003) (infv(i),i=1,mstar)
c
c...Rest Of Iterations Status Change Card(s)
c
      READ (1,9003) (inrv(i),i=1,mstar)
c
c...Plate Descriptor Card(s) -- Each Entry Is A Pair Of Cards
c
c	First contains t, x-pi, y-pi, x-zd, y-zd, w, etc.
c	Second contains the list of terms to be included
c
c	2-FEB-86  Modified to ignore zero weight plates
c
c	WF/PC	tplate field now 7 wide for post-2000 dates
c
      l = 0
      DO i=1,nplate
        l = l+1
        READ (1,9004) j,tplate(l),parfx(l),parfy(l),wplate(l),
     *                pzdx(l),pzdy(l),ieyy(l),iedn(l),iehh(l),
     *                iemm(l),iess(l),pmcon(l),pmsig(l)
        READ (1,9008) (inxfit(k,l),k=1,lc),(inyfit(k,l),k=1,lc),
     *                killpl(l)
        lookp(l) = j
        IF (wplate(l).le.0.0) THEN
          l = l-1
        ENDIF
      ENDDO
      nplate = l
c
c...Measures Cards
c
c	Terminated by a blank card.
c
c	01-feb-86: Added logic for fwhm, sky, seeing
c			ccd parallax program coordintate system
c
      nstar = mstar
  220 read (1,9001,end=399) chcard
      IF (inform.eq.0) THEN
        GO TO 230
      ELSEIF (inform.eq.1) THEN
        READ (chcard,9017,err=230) jstar,jplate,x,y,sky,ix,iy,
     *                             sm1,sm2,idn,em1,em2
      ENDIF
      fwx = ix
      fwy = iy
      sdn = idn
      IF ((sm1.le.0.0).or.(sm1.ge.30.0)) sm1=tag
      IF ((sm2.le.0.0).or.(sm2.ge.30.0)) sm2=tag
      IF ((em1.lt.0.0).or.(em1.ge. 5.0)) em1=tag
      IF ((em2.lt.0.0).or.(em2.ge. 5.0)) em2=tag
      GO TO 240
  230 READ (chcard,9005,err=220) jstar,jplate,x,y
      sky = tag
      fwx = tag
      fwy = tag
      sdn = tag
      sm1 = tag
      sm2 = tag
      em1 = tag
      em2 = tag
  240 IF ((jstar.eq.0).and.(jplate.eq.0)) GO TO 400
      istar = jstar
      abar(istar) = abv(istar)
      acol(istar) = acv(istar)
      infrst(istar) = infv(istar)
      inrest(istar) = inrv(istar)
      numfit(istar) = inqv(istar)
c
c...Look Up Plate
c
  250 iplate = jplate
c
c...Star/Plate Are OK.  Now Store Data
c
  260 xcoord(istar,iplate) = x
      ycoord(istar,iplate) = y
      xfwhm(istar,iplate)  =  fwx
      yfwhm(istar,iplate)  =  fwy
      skydn(istar,iplate)  =  sky
      stardn(istar,iplate) = sdn
      smag1(istar,iplate) = sm1
      smag2(istar,iplate) = sm2
      emag1(istar,iplate) = em1
      emag2(istar,iplate) = em2
      GO TO 220
c
c===========================================================================
c
c...We get here on end of card entry phase.  Print stuff
c
c	(399) -- Error On Reading A Measures Card
c	(400) -- Blank Measures Card
c
  399 ifind = 1
  400 WRITE (2,9010,iostat=junk) (ititle(i),i=1,lt)
      i = 0
      DO istar=1,nstar
        IF ((infrst(istar).eq.0).and.(inrest(istar).eq.0)) THEN
          i = i+1
          infv(i) = looks(istar)
        ENDIF
      ENDDO
      WRITE (2,9014,iostat=junk) aamin,aamax,ccmin,ccmax
      IF (i.gt.0) THEN
          WRITE (2,9013,iostat=junk) (infv(j),j=1,i)
      ENDIF
      WRITE (2,9012,iostat=junk) flagmn,flagmx,convl,rejpcl,fdamp
      DO i=1,nplate
        WRITE (2,9011,iostat=junk) lookp(i),tplate(i),parfx(i),
     *        parfy(i),pzdx(i),pzdy(i),wplate(i),
     *        (inxfit(k,i),k=1,nxfit),(inyfit(k,i),k=1,nyfit)
      ENDDO
c
c...IPARST and IPICK point to the parallax and first guess plate indices
c
      DO iparst=1,nstar
        IF (jparst.eq.looks(iparst)) GO TO 410
      ENDDO
      iparst = 0
  410 DO ipick=1,nplate
        IF (jpick.eq.lookp(ipick)) GO TO 420
      ENDDO
      IF (jpick.gt.0) THEN
        ipick = 1
      ELSE
        ipick=0
      ENDIF
  420 CONTINUE
c
c...Remove stars with less than 2 measures
c
      DO istar=1,nstar
        n = 0
        DO iplate=1,nplate
          IF   ((xcoord(istar,iplate).ne.tag)
     *     .and.(ycoord(istar,iplate).ne.tag)) THEN
            n=n+1
          ENDIF
        ENDDO
        IF (n.le.1) THEN
          infrst(istar) = 0
          inrest(istar) = 0
        ENDIF
      ENDDO
c
c...Remove Stars According to Number Of Measures
c
      IF ((nummin.gt.0).or.(nummax.gt.0)) THEN
        WRITE (*,9021) nummin,nummax
        WRITE (2,9021) nummin,nummax
        DO istar=1,nstar
          n = 0
          DO iplate=1,nplate
            IF   ((xcoord(istar,iplate).ne.tag)
     *       .and.(ycoord(istar,iplate).ne.tag)) THEN
              n=n+1
            ENDIF
          ENDDO
          IF ((nummin.gt.0).and.(nummax.le.0)) THEN
            IF (n.lt.nummin) THEN
              WRITE (*,9022) looks(istar),n
              WRITE (2,9022) looks(istar),n
              infrst(istar) = 0
              inrest(istar) = 0
            ENDIF
          ELSEIF ((nummin.le.0).and.(nummax.gt.0)) THEN
            IF (n.gt.nummax) THEN
              WRITE (*,9022) looks(istar),n
              WRITE (2,9022) looks(istar),n
              infrst(istar) = 0
              inrest(istar) = 0
            ENDIF
          ELSE
            IF ((n.lt.nummin).or.(n.gt.nummax)) THEN
              WRITE (*,9022) looks(istar),n
              WRITE (2,9022) looks(istar),n
              infrst(istar) = 0
              inrest(istar) = 0
            ENDIF
          ENDIF
        ENDDO
      ENDIF
c
c...Recompute parallax factors/zenith distances
c
c==>      CALL newpfzd(ieyy,iedn,iehh,iemm,iess,iflt,itel)
c
c...Use photometry to remove zenith distance effect
c
c==>      CALL dophzd
c
c...Mean x and y coordinate of each plate are subtracted
c
c==>      CALL nullmean
c
c...Load the user's values for the zenith distance coefficients.
c
c==>      CALL  zdload
c
c...Sort Star And Plate Tables To Assist Humans
c
      DO istar=1,nstar
        issort(istar) = istar
        rs(istar) = looks(istar)
      ENDDO
      CALL qsrt(nstar,rs,issort)
      DO iplate=1,nplate
        ipsort(iplate) = iplate
        rp(iplate) = lookp(iplate)
      ENDDO
      CALL qsrt(nplate,rp,ipsort)
      RETURN
      END
