      SUBROUTINE  sstats
c
c...Report Statistics Based On Sorted Residuals
c
c	WARNING:  Trashes EMAG1/2 And SMAG1
c
      INCLUDE
     *            'pa6inc1.inc'
      INTEGER
     *            istar, iplate, nx, ny, dum(LS*LP), i, n
      REAL
     *            xar(LS*LP), yar(LS*LP), w
      EQUIVALENCE
     *            (xar(1),emag1(1,1)), (yar(1),emag2(1,1)),
     *            (dum(1),smag1(1,1))
c
 9001 FORMAT (' X Gaussian Probabilty 1Sig=', f8.3, '   2Sig=', f8.3,
     *        '   3Sig=', f8.3)
 9002 FORMAT (' Y                     1Sig=', f8.3, '   2Sig=', f8.3,
     *        '   3Sig=', f8.3)
c
c...Fill And Sort Residuals
c
  100 nx = 0
      ny = 0
      DO iplate=1,nplate
        w = SQRT(wplate(iplate))
        DO istar=1,nstar
          IF (instar(istar).ne.0) THEN
            IF (xresid(istar,iplate).ne.TAG) THEN
              nx = nx+1
              xar(nx) = w*ABS(xresid(istar,iplate))
            ENDIF
            IF (yresid(istar,iplate).ne.TAG) THEN
              ny = ny+1
              yar(ny) = w*ABS(yresid(istar,iplate))
            ENDIF
          ENDIF
        ENDDO
      ENDDO
      n = MAX(nx,ny)
      DO i=1,n
        dum(i) = i
      ENDDO
      CALL qsrt(nx,xar,dum)
      CALL qsrt(ny,yar,dum)
c
c...Get Sigmas From Gaussian Probability
c
      n1 = 0.683*nx
      n2 = 0.954*nx
      n3 = 0.997*nx
      WRITE (*,9001) xar(n1),xar(n2),xar(n3)
      WRITE (2,9001) xar(n1),xar(n2),xar(n3)
      n1 = 0.683*ny
      n2 = 0.954*ny
      n3 = 0.997*ny
      WRITE (*,9002) yar(n1),yar(n2),yar(n3)
      WRITE (2,9002) yar(n1),yar(n2),yar(n3)
c
c...That's All
c
      RETURN
      END
