      PROGRAM  genacrs
c
c...Read ASCII ACRS 1+2 Catalog And Sort On RA
c
c	NOTE:  Uses same units as TYCHO
c
      INCLUDE
     *          'possacrs.inc'
      PARAMETER
     *          spd = (90*3600*100)
      CHARACTER*192
     *          lb
      INTEGER
     *          i, id, r, d, m
      DOUBLE PRECISION
     *          rh, rm, rs, dd, dm, ds, mag, pmra, pmdec, x, y
c
 9001 FORMAT (1x, i6, 1x, f2.0, f2.0, f5.3, f3.0, f2.0, f4.2, 55x, f5.2)
 9002 FORMAT (a)
 9003 FORMAT (1x, i6, 74x, f5.2, 64x, f2.0, f2.0, f5.3, f6.3, 6x, f3.0,
     *        f2.0, f4.2, f6.2)
c
c...Read ACRS1
c
  100 OPEN (
     *       access='sequential',
     *       carriagecontrol='list',
     *       dispose='keep',
     *       form='formatted',
     *       name='/uz6/xpmm/sg5/tycho/ACRS1.DAT',
     *       readonly,
     *       shared,
     *       status='old',
     *       unit=1
     *      )
      DO i=1,NACRS1
        READ (1,9002) lb
        READ (lb,9003) id,mag,rh,rm,rs,pmra,dd,dm,ds,pmdec
        r = 1500.0D00*(   (rh)*3600.0D00 + rm*60.0D00 + rs) + 0.5D00
        d =  100.0D00*(ABS(dd)*3600.0D00 + dm*60.0D00 + ds) + 0.5D00
        IF (INDEX(lb(172:174),'-').gt.0) THEN
          d = -d
        ENDIF
        m = 100.0D00*mag + 0.5D00
        x = 150.0D00*pmra*COSD(d/360000.0D00)
        y =  10.0D00*pmdec
        acrsid(i) = id
        ra10mas(i) = r
        spd10mas(i) = d+SPD
        v10mmag(i) = m
        mux1mas(i) = x
        muy1mas(i) = y
      ENDDO
      CLOSE (1)
c
c...Read ACRS2
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='/uz6/xpmm/sg5/tycho/ACRS2.DAT',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      DO i=1,NACRS2
        READ (1,9002) lb
        READ (lb,9003) id,mag,rh,rm,rs,pmra,dd,dm,ds,pmdec
        r = 1500.0D00*(   (rh)*3600.0D00 + rm*60.0D00 + rs) + 0.5D00
        d =  100.0D00*(ABS(dd)*3600.0D00 + dm*60.0D00 + ds) + 0.5D00
        IF (INDEX(lb(172:174),'-').gt.0) THEN
          d = -d
        ENDIF
        m = 100.0D00*mag + 0.5D00
        x = 150.0D00*pmra*COSD(0.01D00*d)
        y = 10.0D00*pmdec
        acrsid(i+NACRS1) = id
        ra10mas(i+NACRS1) = r
        spd10mas(i+NACRS1) = d+SPD
        v10mmag(i+NACRS1) = m
        mux1mas(i+NACRS1) = x
        muy1mas(i+NACRS1) = y
      ENDDO
      CLOSE (1)
c
c...Sort And ReOrder
c
      DO i=1,NMAX
        idx(i) = i
      ENDDO
      CALL iuqsrt(NMAX,ra10mas,idx)
      CALL ireord(NMAX,idx,spd10mas,tmp)
      CALL ireord(NMAX,idx, v10mmag,tmp)
      CALL ireord(NMAX,idx,  acrsid,tmp)
      CALL ireord(NMAX,idx, mux1mas,tmp)
      CALL ireord(NMAX,idx, muy1mas,tmp)
c
c...Save As A Direct Access File
c
      OPEN (
     *       access='direct',
     *       carriagecontrol='none',
     *       convert='big_endian',
     *       dispose='keep',
     *       form='unformatted',
     *       name='/uz6/xpmm/sg5/tycho/acrs.srt',
     *       recl=NMAX,
     *       recordtype='fixed',
     *       status='unknown',
     *       unit=1
     *      )
      WRITE (1,rec=1) acrsid
      WRITE (1,rec=2) ra10mas
      WRITE (1,rec=3) spd10mas
      WRITE (1,rec=4) v10mmag
      WRITE (1,rec=5) mux1mas
      WRITE (1,rec=6) muy1mas
      CLOSE (1)
      CALL EXIT
      END
