      SUBROUTINE  nodup2(rad)
c
c...Make A Flag Array For Duplicate Entries In List 2
c
      INCLUDE
     *            'cuproc.inc'
      PARAMETER
     *            nfindmax = 1000
      REAL
     *            rad, dx, dy, rsqr, xbar, ybar, dr, drtest
      INTEGER
     *            i, no2, x, y, twor, test, low, high, ifind(NFINDMAX),
     *            nfind, j, k
c
 9001 FORMAT (' N2=', i10, ' After NODUP2')
c
c...Initialize
c
  100 DO i=1,n2
        IF ((x2(i).lt.LSANITY).or.(x2(i).gt.HSANITY)
     *  .or.(y2(i).lt.LSANITY).or.(y2(i).gt.HSANITY)) THEN
          flag2(i) = SANITYTAG
        ELSE
          flag2(i) = 0
        ENDIF
      ENDDO
      low = 0
      high = 0
      no2 = 0
      twor = 200.0*rad + 0.5
      rsqr = 10000.0*rad*rad
c
c...Outer Loop Find Next Star Without An ID
c
  110 low = low+1
      IF (low.gt.n2) GO TO 130
      IF (flag2(low).ne.0) GO TO 110
      x = x2(low)
      y = y2(low)
c
c...Inner Loop Finds Last Star Without An ID That Is Inside Radius
c
      test = MAX(high,low)
      high = test
  120 IF (test.lt.n2) THEN
        test = test+1
        IF (flag2(test).ne.0) GO TO 120
        IF ((x2(test)-x).le.twor) THEN
          high = test
          GO TO 120
        ENDIF
      ENDIF
c
c...Examine All Stars In This Range
c
      IF (high.le.low) THEN
        no2 = no2+1
        flag2(low) = no2
        GO TO 110
      ENDIF
      nfind = 1
      ifind(nfind) = low
      DO test=low+1,high
        IF (flag2(test).eq.0) THEN
          dx = x2(test)-x
          dy = y2(test)-y
          IF ((dx*dx+dy*dy).le.rsqr) THEN
            IF (nfind.lt.NFINDMAX) THEN
              nfind = nfind+1
              ifind(nfind) = test
            ENDIF
          ENDIF
        ENDIF
      ENDDO
c
c...Processing Depends On Number Found
c
c	Algorithm Is To Keep Brightest
c
      no2 = no2+1
      IF (nfind.le.1) THEN
        flag2(low) = no2
      ELSE
        test = 1
        drtest = d2(ifind(test))
        DO i=2,nfind
          dr = d2(ifind(i))
          IF (dr.lt.drtest) THEN
            test = i
            drtest = dr
          ENDIF
        ENDDO
        DO i=1,nfind
          flag2(ifind(i)) = -no2
        ENDDO
        flag2(ifind(test)) = no2
      ENDIF
      GO TO 110
c
c...Just Count.  FLAG2 Will Be Used To Avoid Duplicates.
c
  130 j = 0
      DO i=1,n2
        IF (flag2(i).gt.0) THEN
          j = j+1
        ENDIF
      ENDDO
      WRITE (*,9001) j
      RETURN
      END
