      SUBROUTINE  possload
c
c...Look In Database To Fill In Exposure Info
c
      INCLUDE
     *            'cuproc.inc'
      PARAMETER
     *            palomar = 33.357D00
      DOUBLE PRECISION
     *            a, b, c, czd, yy, dd, x, y, z
      INTEGER
     *            nlb, field, i, nleap(12), yleap(12), leap
      CHARACTER*132
     *            lb
      CHARACTER*3
     *            mm, month(12)
      DATA
     *   month/'JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN',
     *         'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC'/,
     *   nleap/0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334/,
     *   yleap/0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335/
c
 9001 FORMAT (q, a)
 9002 FORMAT (i4)
 9003 FORMAT (3f2.0)
 9004 FORMAT (f1.0, 1x, f2.0)
 9005 FORMAT (' Fatal Error', 5(' >>', a, '<<'))
 9006 FORMAT (f2.0, a, f2.0)
c
c...Open Catalog
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='/uz6/xpmm/sg5/tycho/possii.cat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=77
     *     )
      READ (77,9001)
      DO i=1,NFDIM
        ra(i) = 0.0D00
        dec(i) = 0.0D00
        ha(i) = 0.0D00
        zd(i) = 0.0D00
        ep(i) = 0.0D00
      ENDDO
c
c...Read And Keep Only UJ Entries
c
  110 READ (77,9001,err=110,end=130) nlb,lb
      IF (nlb.le.0) GO TO 110
      IF (lb(8:9).ne.'UJ') GO TO 110
      READ (lb(3:6),9002,err=200) field
      READ (lb(30:35),9003,err=200) x,y,z
      ra(field) = x + y/60.0D00 + z/3600.0D00
      READ (lb(38:43),9003,err=200) x,y,z
      dec(field) = x + y/60.0D00 + z/3600.0D00
      IF (lb(37:37).eq.'-') THEN
        dec(field) = -dec(field)
      ENDIF
      READ (lb(84:87),9004,err=200) x,y
      ha(field) = x + y/60.0D00
      IF (lb(88:88).eq.'E') THEN
        ha(field) = -ha(field)
      ENDIF
c
c...Compute Epoch
c
      READ (lb(16:22),9006,err=200) dd,mm,yy
      i = yy+0.5D00
      IF (MOD(i,4).eq.0) THEN
        leap = 1
      ELSE
        leap = 0
      ENDIF
      DO i=1,12
        IF (mm.eq.month(i)) THEN
          IF (leap.eq.0) THEN
            ep(field) = yy + (dd+nleap(i)-0.5D00)/365.0D00
          ELSE
            ep(field) = yy + (dd+yleap(i)-0.5D00)/366.0D00
          ENDIF
          GO TO 120
        ENDIF
      ENDDO
      GO TO 200
c
c...Compute ZD
c
  120 b = 90.0D00 - PALOMAR
      c = 90.0D00 - dec(field)
      czd = COSD(b)*COSD(c) + SIND(b)*SIND(c)*COSD(15.0D00*ha(field))
      zd(field) = ACOSD(czd)
      GO TO 110
  130 CLOSE (77)
      RETURN
c
c...Problems
c
  200 WRITE (*,9005) lb(3:6),lb(30:35),lb(37:43),lb(84:88),lb(16:22)
      CLOSE (77)
      CALL EXIT
      END
